<?php

/**
 * This is the model class for table "{{mas_footer_items}}".
 *
 * The followings are the available columns in table '{{mas_footer_items}}':
 * @property integer $id
 * @property integer $sales_purchase_type
 * @property integer $account_id
 * @property integer $subledger_id
 * @property integer $item_type
 * @property string $item_name
 * @property string $description
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasLandedCostItems extends CActiveRecord
{

    /**
     * @return string the associated database table name
     */
     
     public $subledger_name;
     public $have_sub_ledger;
    public function tableName()
    {
            return '{{mas_landed_cost_items}}';
    }
    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
            // NOTE: you should only define rules for those attributes that
            // will receive user inputs.
            return array(
                    array('item_type, item_name', 'required'),
                    array('account_id, subledger_id, item_type, created_by, updated_by', 'numerical', 'integerOnly'=>true),
                    array('item_name, description', 'length', 'max'=>255),
                    array('subledger_id', 'validateSubledger'),
                    // The following rule is used by search().
                    // @todo Please remove those attributes that should not be searched.
                    array('id, account_id, subledger_id, item_type, item_name, description, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
            );
    }
    
    public function validateSubledger($attribute,$params) {
        if ((int)$this->subledger_id == 0 && $this->have_sub_ledger=='Y') {
            $this->addError('subledger_id', 'Subledger cannot be blank');
             return false;
        }
        return true;
    }

    /**

     * @return array relational rules.

     */
    public function relations() {

        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'ledger' => array(self::BELONGS_TO, 'FinanceLegder', 'account_id'),
            'subledger' => array(self::BELONGS_TO, 'FinanceSubledger', 'subledger_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
            return array(
                    'id' => 'ID',
                    'account_id' => 'fin_accont_id',
                    'subledger_id' => 'Subledger',
                    'item_type' => 'Item Type',
                    'item_name' => 'Item Name',
                    'description' => 'Description',
                    'created_by' => 'Created By',
                    'created_date_time' => 'Created Date Time',
                    'updated_by' => 'Updated By',
                    'updated_date_time' => 'Updated Date Time',
            );
    }


	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);		
		$criteria->compare('account_id',$this->account_id);
		$criteria->compare('subledger_id',$this->subledger_id);
		$criteria->compare('item_type',$this->item_type);
		$criteria->compare('item_name',$this->item_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Customers the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
    public static function getLandedCostItems()
    {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'item_name');
    }
    public static function getLandedCostAdditions() {
		$condition = 'sales_purchase_type = 2 AND item_type=1 and isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order' => 'item_name'));
		return CHtml::listData($model, 'id', 'item_name');
	}
	
	public static function getLandedCostDeductions() {
		$condition = 'item_type=2 and isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order' => 'item_name'));
		return CHtml::listData($model, 'id', 'item_name');
	}
    public static function getLandedCostItemName($particular_id=0) {
	    if($particular_id > 0){
    		$model = self::model()->findByPk($particular_id);
    		return $model->item_name;
	    }
	    else
	    {
	        return "";
	    }
	}
	public static function getLandedCostItemType($particular_id=0) {//addition/deduction
			$model = self::model()->findByPk($particular_id);
    		return $model->item_type;
    }
    
    public function getAccount( $id ){
        return (int) self::model()->findBypk( $id )->account_id;
    }

    public function getSubledger( $id ){
        return (int) self::model()->findBypk( $id )->subledger_id;
    }
}

