<?php

/**
 * This is the model class for table "{{mas_issue_type}}".
 *
 * The followings are the available columns in table '{{mas_issue_type}}':
 * @property integer $id
 * @property string $type_name
 * @property integer $ledger_id
 * @property string $type_code
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasIssueType extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_issue_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type_name, type_code', 'required'),
			array('ledger_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('type_name', 'length', 'max'=>100),
			array('type_name', 'unique'),
			array('type_code', 'length', 'max'=>10),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, type_name, ledger_id, type_code, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'ledger' => array(self::BELONGS_TO, 'AccLedger', 'ledger_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'type_name' => 'Type Name',
			'ledger_id' => 'Ledger',
			'type_code' => 'Type Code',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('type_name',$this->type_name,true);
		$criteria->compare('ledger_id',$this->ledger_id);
		$criteria->compare('type_code',$this->type_code,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('product_type',$this->product_type,true);
		$criteria->compare('is_default',$this->is_default,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasIssueType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getOilIssueType(){
        $condition = 'isActive = "Y" AND product_type="O" AND type_code!="SO"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'type_name'));
        return CHtml::listData($model, 'id', 'type_name');
    }
    public static function getMachineIssueType(){
        $condition = 'isActive = "Y" AND product_type="M" AND type_code!="SM"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'type_name'));
        return CHtml::listData($model, 'id', 'type_name');
    }
    public static function getIssueType(){
        $condition = 'isActive = "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'type_name'));
        return CHtml::listData($model, 'id', 'type_name');
    }
    
    public static function getTrialIssueType(){
        $arr_ids=[];
        $condition = 'isActive = "Y" AND (type_code="TO" OR type_code="TM") ';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'type_name'));
        foreach($model as $each){
            $arr_ids[]=$each->id;
        }
        return $arr_ids;
    }
    
    public static function getContractIssueType(){
        $arr_ids=[];
        $condition = 'isActive = "Y" AND (type_code="CO" OR type_code="CM") ';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'type_name'));
        foreach($model as $each){
            $arr_ids[]=$each->id;
        }
        return $arr_ids;
    }
    
}
