<?php

/**
 * This is the model class for table "{{mas_invoice_type}}".
 *
 * The followings are the available columns in table '{{mas_invoice_type}}':
 * @property integer $id
 * @property string $inv_type
 * @property string $percentage
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property InventoryItems[] $inventoryItems
 */
class MasInvoiceType extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_invoice_type}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('inv_type, inv_name , tax , inv_code, start_serial_no,cn_start_serial_no', 'required'),
            array('inv_type, inv_name', 'length', 'max' => 255),
            array('inv_name', 'filter', 'filter'=>'trim'),
            array('inv_name', 'unique'),
            array('is_default', 'length', 'max' => 1),            
            //array('warehouse_id', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, inv_type, inv_name, tax, account_no, is_default,created_by,updated_by,created_datetime,updated_datetime,warehouse_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'account' => array(self::BELONGS_TO, 'FinAccounts', 'account_no'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'inv_type' => 'Invoice Type',
            'inv_name' => 'Invoice Name',
            'tax' => 'Tax',
            'account_no' => 'Tax Value',
            'sales_purchase_account_no' => 'Sales/Purchase Account No',
            'is_default' => 'Is Default',
        );
    }

    

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasInvTax the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

       public static function getInvoceType($type) {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'inv_type =  "'.$type.'"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'inv_name');
    }

}
