<?php

/**
 * This is the model class for table "{{mas_inventory_stock_adjustment_type}}".
 *
 * The followings are the available columns in table '{{mas_inventory_stock_adjustment_type}}':
 * @property integer $id
 * @property string $description
 * @property string $code
 * @property string $type
 * @property integer $ledger_id
 * @property integer $subledger_id
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class MasInventoryStockAdjustmentType extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_inventory_stock_adjustment_type}}';
	}
	
public 	$subledger_name;

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('description,type', 'required'),
			// array('code,description', 'unique'),
			array('ledger_id, subledger_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('description', 'length', 'max'=>255),
			array('code', 'length', 'max'=>25),
			array('type, isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, description, code, type, ledger_id, subledger_id, isActive, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
		    
		    'ledger' => array(self::BELONGS_TO, 'AccLedger', 'ledger_id'),
			'subledger' => array(self::BELONGS_TO, 'AccSubledger', 'subledger_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'description' => 'Description',
			'code' => 'Code',
			'type' => 'Type',
			'ledger_id' => 'Ledger',
			'subledger_id' => 'Subledger',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('ledger_id',$this->ledger_id);
		$criteria->compare('subledger_id',$this->subledger_id);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasInventoryStockAdjustmentType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
    public static function getInventoryStockAdjustmentType_code_issue() {
        $condition = 'isActive =  "Y" AND type =  "I" ';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
        return CHtml::listData($model, 'code', 'description');
    }
    
    	
	 public static function getInventoryStockAdjustmentType_code_receipt() {
        $condition = 'isActive =  "Y" AND type =  "R" ';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'id'));
        return CHtml::listData($model, 'code', 'description');
    }
    
}
