<?php

/**
 * This is the model class for table "{{mas_inventory_item_type}}".
 *
 * The followings are the available columns in table '{{mas_inventory_item_type}}':
 * @property integer $id
 * @property string $item_type
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasInventoryItemType extends CActiveRecord
{
    PUBLIC CONST MACHINE = 4;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_inventory_item_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('item_type', 'required'),
			array('created_by, updated_by,ledger_id', 'numerical', 'integerOnly' => true),
			array('item_type', 'length', 'max' => 50),
			array('isActive', 'length', 'max' => 1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, item_type, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'item_type' => 'Item Type',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('item_type', $this->item_type, true);
		$criteria->compare('isActive', $this->isActive, true);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('created_date_time', $this->created_date_time, true);
		$criteria->compare('updated_by', $this->updated_by);
		$criteria->compare('updated_date_time', $this->updated_date_time, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasInventoryItemType the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}
	public static function getAll()
	{
		$erpSetting = MasCompany::getCurrentUserERPSetting();
		$condition = 't.isActive =  "Y"';

		$model = self::model()->findAll(array('condition' => $condition, 'order' => 'id'));
// 		if ($erpSetting === 'C') {
// 			foreach ($model as $m) {
// 				if ($m->id == 1) {
// 					$m->item_type = 'Machine';
// 				} elseif ($m->id == 2) {
// 					$m->item_type = 'Service';
// 				} elseif ($m->id == 3) {
// 					$m->item_type = 'Oil';
// 				}
// 			}
// 		}
		return CHtml::listData($model, 'id', 'item_type');
	}
	public static function GetDefaultId()
	{
		return self::model()->find(array('select' => 'id', 'condition' => 'isDefault="Y"'))->id;
	}

}
