<?php
class MasGeneric extends CActiveRecord {

    /**

     * @return string the associated database table name

     */

    public function tableName() {

        return '{{inventory_generic_name}}';

    }

    /**

     * @return array validation rules for model attributes.

     */

    public function rules() {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

            array('generic_name', 'required'),
            array('generic_name', 'unique'),
            array('is_Active', 'length', 'max' => 1),
//          array('product_class, description', 'length', 'max' => 255),

            array('id, generic_name,is_Active,generic_description,isDefault,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),

        );

    }

    /**

     * @return array relational rules.

     */
    public function relations() {

        // NOTE: you may need to adjust the relation name and the related

        // class name for the relations automatically generated below.

        return array(
        );
    }

    /**

     * @return array customized attribute labels (name=>label)

     */

    public function attributeLabels() {

        return array(

            'id' => 'ID',
            'generic_name' => 'Generic Name',
            'generic_description' => 'Generic Description',
            'created_by' => 'created_by',
            'created_date_time' => 'created_date_time',
            'updated_by' => 'updated_by',
            'updated_date_time' => 'updated_date_time',
            'is_Active' => 'Is Active',
            'isDefault' => 'Is Default',

        );

    }
public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('generic_name',$this->generic_name);
        $criteria->compare('generic_description',$this->generic_description);		
                             
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return Store the static model class

     */

    public static function model($className = __CLASS__) {

        return parent::model($className);

    }

    public static function getGenericNames() {
        $condition = 'is_Active =  "Y"';

        $model = self::model()->findAll(array('select' => array('id', 'generic_name'),'condition' => $condition, 'order' => 'generic_name'));

        return CHtml::listData($model, 'id', 'generic_name');

    }
    
     public static function getDefaultGeneric() {
     	$condition = 'is_Active =  "Y" AND isDefault="Y"';
     	$model = self::model()->find(array('condition' => $condition));
     	return $model;
     }

    public static function base_generic_id()
    {
        return self::model()->find(array('select' => 'id', 'condition' => 'isDefault="Y"'))->id;
    }

}

