<?php

/**
 * This is the model class for table "{{mas_erp_notification}}".
 *
 * The followings are the available columns in table '{{mas_erp_notification}}':
 * @property integer $id
 * @property string $reference_no
 * @property string $user_ids
 * @property string $notes
 * @property string $notification
 * @property string $notification_date_time
 * @property string $status
 * @property integer $created_by
 * @property string $created_date_time

 */
class MasErpNotification extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_erp_notification}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ids, notes, notification_date_time, created_by, created_date_time', 'required'),
			array('created_by,notification_type', 'numerical', 'integerOnly'=>true),
			array('reference_no, user_ids', 'length', 'max'=>100),
			// array('notification', 'length', 'max'=>255),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, reference_no, user_ids, notes, notification, notification_date_time, status, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'employee' => array(self::HAS_MANY, 'Employee', 'user_id'),
			'userdet' => array(self::HAS_MANY, 'User', 'created_by'),
			'notif' => array(self::BELONGS_TO, 'MasNotificationType', 'notification_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'reference_no' => 'Reference No',
			'user_ids' => 'User Ids',
			'notes' => 'Notes',
			'notification' => 'Notification',
			'notification_date_time' => 'Notification Date Time',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('reference_no',$this->reference_no,true);
		$criteria->compare('user_ids',$this->user_ids,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('notification',$this->notification,true);
		$criteria->compare('notification_date_time',$this->notification_date_time,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasErpNotification the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
