<?php

/**
 * This is the model class for table "{{company_settings}}".
 *
 * The followings are the available columns in table '{{company_settings}}':
 * @property string $id
 * @property string $crm_company_id
 * @property string $permissions
 * @property string $sales_menu
 * @property string $purchase_menu
 * @property string $inventory_menu
 * @property string $mis_menu
 * @property string $hr_menu
 * @property string $accounts_menu
 * @property string $reports_menu
 * @property string $masters_menu
 * @property string $admin_menu
 * @property string $projects_menu
 * @property string $fm_menu
 * @property integer $create_by
 * @property string $create_date_time
 */
class MasCompanySettings extends CActiveRecord
{
	public $fixed_asset_menu;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{company_settings}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('crm_company_id, print_template_id, print_template_logo, create_by, create_date_time,package_type,generate_invoice_no,direct_order,direct_purchase_order,direct_quotation,no_of_decimals', 'required'),
			array('create_by', 'numerical', 'integerOnly'=>true),
			array('sales_menu, purchase_menu, inventory_menu, mis_menu, hr_menu, accounts_menu, reports_menu, masters_menu, admin_menu, projects_menu, fm_menu,direct_order,direct_purchase_order', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, crm_company_id, permissions, sales_menu, purchase_menu, inventory_menu,no_of_decimals, mis_menu, hr_menu, accounts_menu, reports_menu, masters_menu, admin_menu, projects_menu, fm_menu,stock_lock_flag, create_by, create_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'crm_company_id' => 'Crm Company',
			'permissions' => 'Permissions',
			'sales_menu' => 'Sales Menu',
			'purchase_menu' => 'Purchase Menu',
			'inventory_menu' => 'Inventory Menu',
			'mis_menu' => 'Mis Menu',
			'hr_menu' => 'Hr Menu',
			'accounts_menu' => 'Accounts Menu',
			'reports_menu' => 'Reports Menu',
			'masters_menu' => 'Masters Menu',
			'admin_menu' => 'Admin Menu',
			'projects_menu' => 'Projects Menu',
			'fm_menu' => 'Fm Menu',
			'create_by' => 'Create By',
			'create_date_time' => 'Create Date Time',
			'package_type'=>'Package Type'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('crm_company_id',$this->crm_company_id,true);
		$criteria->compare('permissions',$this->permissions,true);
		$criteria->compare('sales_menu',$this->sales_menu,true);
		$criteria->compare('purchase_menu',$this->purchase_menu,true);
		$criteria->compare('inventory_menu',$this->inventory_menu,true);
		$criteria->compare('mis_menu',$this->mis_menu,true);
		$criteria->compare('hr_menu',$this->hr_menu,true);
		$criteria->compare('accounts_menu',$this->accounts_menu,true);
		$criteria->compare('reports_menu',$this->reports_menu,true);
		$criteria->compare('masters_menu',$this->masters_menu,true);
		$criteria->compare('admin_menu',$this->admin_menu,true);
		$criteria->compare('projects_menu',$this->projects_menu,true);
		$criteria->compare('fm_menu',$this->fm_menu,true);
		$criteria->compare('create_by',$this->create_by);
		$criteria->compare('create_date_time',$this->create_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasCompanySettings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
