<?php

/**
 * This is the model class for table "{{hr_mas_approve_setting}}".
 *
 * The followings are the available columns in table '{{hr_mas_approve_setting}}':
 * @property integer $id
 * @property string $functionality_name
 * @property string $max_level
 * @property string $isActive
 */
class MasApproveSetting extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_mas_approve_setting}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('functionality_name', 'required'),
			array('functionality_name', 'length', 'max'=>500),
			array('isActive', 'length', 'max'=>1),
			array('max_level', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, functionality_name, max_level, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'branch' => array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'functionality_name' => 'Functionality Name',
			'max_level' => 'Max Level',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('functionality_name',$this->functionality_name,true);
		$criteria->compare('max_level',$this->max_level,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasApproveSetting the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getnamedetails() {
            $condition = 'isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition));
            return CHtml::listData($model, 'id', 'functionality_name');
        }
}
