<?php

/**
 * This is the model class for table "{{mas_aidashboard_settings_data}}".
 *
 * The followings are the available columns in table '{{mas_aidashboard_settings_data}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $rating_id
 * @property integer $rating
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasAidashboardSettingsData extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_aidashboard_settings_data}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, rating_id, rating, created_by, created_date_time', 'required'),
			array('customer_id, rating_id, rating, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, rating_id, rating, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'aidashboardsettings' => array(self::BELONGS_TO, 'MasAidashboardSettings', 'rating_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer Id',
			'rating_id' => 'Rating',
			'rating' => 'Rating',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('rating_id',$this->rating_id);
		$criteria->compare('rating',$this->rating);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasAidashboardSettingsData the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function getDashboardSettingsRating($customer_id) {
		$customerRating = 0;
		$modelMasAidashboardSettingsData = self::model()->with('aidashboardsettings')->findAll(array('condition'=>'ai_type="SA" AND isActive="Y" AND customer_id='.$customer_id));
		if ($modelMasAidashboardSettingsData) {
			foreach ($modelMasAidashboardSettingsData as $mmadsdKey => $modelMasAidashboardSettingsDataItem) {
				$ratingWeitage = $modelMasAidashboardSettingsDataItem->aidashboardsettings->weigtage;
				$customerRating += ($modelMasAidashboardSettingsDataItem->rating * ($ratingWeitage/100));
			}
		}
		return number_format($customerRating,2);
	}
}
