<?php

/**
 * This is the model class for table "{{mas_aidashboard_settings}}".
 *
 * The followings are the available columns in table '{{mas_aidashboard_settings}}':
 * @property integer $id
 * @property string $ai_type
 * @property string $serial_no
 * @property string $description
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasAidashboardSettings extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_aidashboard_settings}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ai_type,description', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('ai_type', 'length', 'max'=>2),
			array('serial_no', 'length', 'max'=>50),
			array('description', 'length', 'max'=>500),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, ai_type, serial_no, description, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'details' => array(self::HAS_MANY, 'MasAidashboardSettings', 'id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'ai_type' => 'SA-Sales,PR-Purchase,PO-Production Order,CF-Contact Favourite,ST-Stock/Inventory,FI-Finance,IN-Info',
			'serial_no' => 'Serial No',
			'description' => 'Description',
			'weigtage' => 'Weigtage',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('ai_type',$this->ai_type,true);
		$criteria->compare('serial_no',$this->serial_no,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasAidashboardSettings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getAiTypeOptions()
    {
        return array(
            'SA' => 'Sales',
            'PR' => 'Purchase',
            'PO' => 'Production',
            'CF' => 'Contact',
            'ST' => 'Inventory',
            'FI' => 'Finance',
            'IN' => 'Info',
        );
    }

    public function getAiTypeLabel()
    {
        $types = self::getAiTypeOptions();
        return isset($types[$this->ai_type]) ? $types[$this->ai_type] : $this->ai_type;
    }

  
	
}
