<?php

/**
 * This is the model class for table "{{machine_profile_parts}}".
 *
 * The followings are the available columns in table '{{machine_profile_parts}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $pdt_location_id
 * @property string $part
 * @property string $description
 * @property string $serial_no
 * @property integer $year_manufacture
 * @property string $document_upload
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MachineProfileParts extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{machine_profile_parts}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id,serial_no', 'required'),
			array('product_id, pdt_location_id, year_manufacture, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('part,part_serial_no, description, document_upload', 'length', 'max'=>500),
			array('serial_no', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, pdt_location_id,serial_no,part, description, part_serial_no, year_manufacture, document_upload, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'pdt_location_id' => 'Pdt Location',
			'part' => 'Part',
			'description' => 'Description',
			'serial_no' => 'Serial No',
			'year_manufacture' => 'Year Manufacture',
			'document_upload' => 'Document Upload',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('pdt_location_id',$this->pdt_location_id);
		$criteria->compare('part',$this->part,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('serial_no',$this->serial_no,true);
		$criteria->compare('year_manufacture',$this->year_manufacture);
		$criteria->compare('document_upload',$this->document_upload,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MachineProfileParts the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
