<?php

/**
 * This is the model class for table "{{invoice_advance_deduction}}".
 *
 * The followings are the available columns in table '{{invoice_advance_deduction}}':
 * @property integer $id
 * @property integer $invoice_id
 * @property integer $order_id
 * @property integer $order_advance_invoice_id
 * @property string $description
 * @property string $total_amount
 * @property string $tax_amount
 * @property string $advance_deduction
 * @property integer $created_by
 * @property string $created_date_time
 */
class InvoiceAdvanceDeduction extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{invoice_advance_deduction}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_id, order_advance_invoice_id, description, total_amount, tax_amount, advance_deduction, created_by, created_date_time', 'required'),
			array('invoice_id, order_id, order_advance_invoice_id, created_by', 'numerical', 'integerOnly'=>true),
			array('total_amount, tax_amount, advance_deduction', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, invoice_id, order_id, order_advance_invoice_id, description, total_amount, tax_amount, advance_deduction, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'invoice_id' => 'Invoice',
			'order_id' => 'Order',
			'order_advance_invoice_id' => 'Order Advance Invoice',
			'description' => 'Description',
			'total_amount' => 'Total Amount',
			'tax_amount' => 'Tax Amount',
			'advance_deduction' => 'Advance Deduction',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('invoice_id',$this->invoice_id);
		$criteria->compare('order_id',$this->order_id);
		$criteria->compare('order_advance_invoice_id',$this->order_advance_invoice_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('total_amount',$this->total_amount,true);
		$criteria->compare('tax_amount',$this->tax_amount,true);
		$criteria->compare('advance_deduction',$this->advance_deduction,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InvoiceAdvanceDeduction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
