<?php

/**
 * This is the model class for table "{{inventory_indirect_received}}".
 *
 * The followings are the available columns in table '{{inventory_indirect_received}}':
 * @property string $id
 * @property string $indirect_transfer_id
 * @property string $to_warehouse_id
 * @property string $intermediate_location
 * @property string $indirect_transfer_description
 * @property string $reference
 * @property string $transfer_date
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 */
class InventoryIndirectReceived extends CActiveRecord
{
	public $receive_date;
        /**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inventory_indirect_received}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('indirect_transfer_id, to_warehouse_id,from_warehouse_id, intermediate_location, transfer_date', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('indirect_transfer_id, to_warehouse_id,from_warehouse_id', 'length', 'max'=>20),
			array('intermediate_location, reference', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, indirect_transfer_id, to_warehouse_id, intermediate_location, indirect_transfer_description, reference, transfer_date, created_by, updated_by, created_date_time, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'stock' => array(self::BELONGS_TO, 'Store', 'item_id'),
                    'warehouseTo' => array(self::BELONGS_TO, 'MasInvWarehouse', 'to_warehouse_id'),
                    'warehouseFrom' => array(self::BELONGS_TO, 'MasInvWarehouse', 'from_warehouse_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'indirect_transfer_id' => 'Indirect Transfer',
			'to_warehouse_id' => 'To Warehouse',
			'intermediate_location' => 'Intermediate Location',
			'indirect_transfer_description' => 'Indirect Transfer Description',
			'reference' => 'Reference',
			'transfer_date' => 'Transfer Date',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_date_time' => 'Created Date Time',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('indirect_transfer_id',$this->indirect_transfer_id,true);
		$criteria->compare('to_warehouse_id',$this->to_warehouse_id,true);
		$criteria->compare('intermediate_location',$this->intermediate_location,true);
		$criteria->compare('indirect_transfer_description',$this->indirect_transfer_description,true);
		$criteria->compare('reference',$this->reference,true);
		$criteria->compare('transfer_date',$this->transfer_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InventoryIndirectReceived the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
