<?php

/**
 * This is the model class for table "{{inventory_goods_issue}}".
 *
 * The followings are the available columns in table '{{inventory_goods_issue}}':
 * @property integer $id

 * @property string $goods_issue_date
 * @property integer $file_id
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property string $isActive
 * @property string $reference
 * @property integer $customer_id
 * @property integer $project_id
 * @property integer $project_classification_id
 */
class InventoryGoodsIssue extends CActiveRecord
{

    /**
     * @return string the associated database table name
     */
    public $project_id_name;
    public $customer_name;
    public $reference_id;

    public function tableName()
    {
        return '{{inventory_goods_issue}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('goods_issue_date,reference, ledger_id,warehouse_id', 'required'),
            array('goods_issue_date,reference,warehouse_id', 'required'),
            array('file_id, production_order_id,customer_id, project_id,lead_owner_id', 'numerical', 'integerOnly' => true),
            array('isActive', 'length', 'max' => 1),
            array('issue_type', 'length', 'max' => 50),
            array('reference, subledger_id', 'length', 'max' => 255),
            array('notes', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,  goods_issue_date, file_id, notes, isActive, reference, customer_id, project_id,lead_owner_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'items' => array(self::HAS_MANY, 'InventoryGoodsIssueItem', 'goods_issue_id'),
            'cost_total' => array(self::STAT, 'InventoryGoodsIssueItem', 'goods_issue_id', 'select' => 'SUM(rate*picked_qty)'),
            'user' => array(self::BELONGS_TO, 'User', 'created_by'),
            'warehouse_det' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),
            'unit_det' => array(self::BELONGS_TO, 'MasBuildingUnit', 'unit_id'),
            'order' => array(self::BELONGS_TO, 'ProductionOrder', 'production_order_id'),
            'item' => array(self::HAS_ONE, 'InventoryGoodsIssueItem', 'goods_issue_id'),//for  oil isse
            'outlet' => array(self::BELONGS_TO, 'CustomerOutletLocation', 'outlet_id'),
            'owner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'goods_issue_date' => 'Goods Issue Date',
            'file_id' => 'File',
            'notes' => 'Notes',
            'terms_and_conditions' => 'Terms And Conditions',
            'remarks' => 'Remarks',
            'isActive' => 'Is Active',
            'reference' => 'Reference',
            'customer_id' => 'Customer',
            'project_id' => 'project_id',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date',
            'created_date_time' => 'Created Date',
            'project_classification_id' => 'Project Classification',
            'warehouse_id' => 'Warehouse',

        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null)
    {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('inventory_goodsissue_search')) : $searchterm;
        $criteria->with = array('file', 'project_idname', 'customer');
        /* $criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND
          file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND'); */
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR
                                        t.file_id like "%' . $searchterm . '%" OR
                                        project_idname.project_id_title like "%' . $searchterm . '%" OR
                                        customer.company_name like "%' . $searchterm . '%" OR
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.goods_issue_date DESC',
            ),
            'pagination' => array('pageSize' => 5),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InventoryGoodsIssue the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function getCustomername()
    {
        return 'N/A';
    }

    public function getCurrency()
    {
        return MasCurrency::base_currency_code();
    }

    public function getExchange_rate()
    {
        return MasCurrency::base_exchange_rate();
    }

}
