<?php

/**
 * This is the model class for table "{{inventory_goods_issue_item}}".
 *
 * The followings are the available columns in table '{{inventory_goods_issue_item}}':
 * @property integer $id
 * @property integer $goods_issue_id
 * @property integer $product_id
 * @property string $product_name
 * @property string $description
 * @property string $unit
 * @property integer $picked_qty
 */
class InventoryGoodsIssueItem extends CActiveRecord {

    public $rate;
    public $warehouse_id;
    public $free_qty;
    public $bom_qty;
    public $balance_qty;
    public $service_id;
    public $file_id;
    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{inventory_goods_issue_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array(' product_id, product_name, description, unit, picked_qty', 'required'),
            array('goods_issue_id, product_id', 'numerical', 'integerOnly' => true),
            array('picked_qty', 'numerical'),
            array('product_name, description', 'length', 'max' => 255),
            array('unit', 'length', 'max' => 20),
            array('picked_qty', 'checkAvailableQty'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, goods_issue_id, product_id, product_name, description, unit, picked_qty', 'safe', 'on' => 'search'),
        );
    }
    
    public function checkAvailableQty($attribute,$params)
    {
    	// if((float) $this->picked_qty > (float) $this->free_qty)
    	// {
    	// 	$this->addError('picked_qty','Picked quantity should be less than free qty');
    	// }
    	if($this->picked_qty!="" && $this->picked_qty<=0){
    		$this->addError('picked_qty','Picked quantity should be grater than 0');
    	}
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unitdetails' => array(self::BELONGS_TO, 'Unit','unit'),
            'inventorygoodsissue' => array(self::BELONGS_TO, 'InventoryGoodsIssue', 'goods_issue_id'),
            'uom' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
            'location' => array(self::BELONGS_TO, 'ServiceCustomerLocation', 'location_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'goods_issue_id' => 'Inventory Goods Issue',
            'product_id' => 'Product',
            'product_name' => 'Product Name',
            'description' => 'Description',
            'unit' => 'Unit',
            'picked_qty' => 'Picked Qty',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('goods_issue_id', $this->goods_issue_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('product_name', $this->product_name, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('unit', $this->unit, true);
        $criteria->compare('picked_qty', $this->picked_qty);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InventoryGoodsIssueItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getLeadownerMachinebySerialno($id, $serial_no)
	{
		$machinenqry = 'SELECT product_id,product_name FROM erp_inventory_goods_issue_item L where L.goods_issue_id=' . (int) $id . ' AND serial_no = "'.$serial_no.'"';
		$modelmachine = Yii::app()->db->createCommand($machinenqry)->queryAll();
		return CHtml::listData($modelmachine, 'product_id', 'product_name');
	}
}
