<?php

/**
 * This is the model class for table "{{inventory_transfer}}".
 *
 * The followings are the available columns in table '{{inventory_transfer}}':
 * @property string $id
 * @property string $stock_id
 * @property string $from_warehouse_id
 * @property string $to_warehouse_id
 * @property string $to_bin_id
 * @property string $to_rack_id
 * @property string $reference
 * @property string $transfer_date
 */
class InventoryDirectTransfer extends CActiveRecord {

    public $from_warehouse_name;
    public $to_warehouse_name;
    public $to_bin_name;
    public $store_product_name;
    public $to_rack_name;
    public $item_description;
    public $lead_owner_name;
    public $customer_name;
    public $production_order_id;
    public $outlet_name;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{inventory_direct_transfer}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('transfer_date, lead_owner_id, to_warehouse_id, from_warehouse_id', 'required'),
            array('from_warehouse_id, to_warehouse_id', 'length', 'max' => 20),
            array('reference', 'length', 'max' => 255),
            array('direct_transfer_description', 'length', 'max' => 5000),
           
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, from_warehouse_id, to_warehouse_id, lead_owner_id,reference, transfer_date', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'warehouseTo' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'to_warehouse_id'),
            'warehouseFrom' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'from_warehouse_id'),
            'items' => array(self::HAS_MANY, 'InventoryDirectTransferItem', 'direct_transfer_id'),
            'user_det' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',            
            'from_warehouse_id' => 'From Warehouse',
            'to_warehouse_id' => 'To Warehouse',
            'lead_owner_id' => 'Technician',
            'customer_id' => 'Customer',
            'outlet_id' => 'Outlet',
            'file_id' => 'Order',
            'transfer_date' => 'Transfer Date',           
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);       
        $criteria->compare('from_warehouse_id', $this->from_warehouse_id, true);
        $criteria->compare('to_warehouse_id', $this->to_warehouse_id, true);        
        $criteria->compare('reference', $this->reference, true);
        $criteria->compare('transfer_date', $this->transfer_date, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.transfer_date,t.from_warehouse_id',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InventoryTransfer the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
