<?php

/**
 * This is the model class for table "{{hiring_repair_history}}".
 *
 * The followings are the available columns in table '{{hiring_repair_history}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $pdt_location_id
 * @property string $damage_quantity
 * @property string $repair_quantity
 * @property string $repair_date
 * @property string $repair_remarks
 * @property integer $created_by
 * @property string $created_date_time
 */
class HiringRepairHistory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hiring_repair_history}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, pdt_location_id, damage_quantity, repair_quantity,warehouse_id, repair_date, created_by, created_date_time', 'required'),
			array('product_id, pdt_location_id, created_by', 'numerical', 'integerOnly'=>true),
			array('damage_quantity, repair_quantity', 'length', 'max'=>15),
			array('repair_remarks', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, pdt_location_id, damage_quantity, repair_quantity, repair_date, repair_remarks, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'pdt_location_id' => 'From hiring',
			'damage_quantity' => 'Damage Quantity',
			'repair_quantity' => 'Repair Quantity',
			'repair_date' => 'Repair Date',
			'repair_remarks' => 'Repair Remarks',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('pdt_location_id',$this->pdt_location_id);
		$criteria->compare('damage_quantity',$this->damage_quantity,true);
		$criteria->compare('repair_quantity',$this->repair_quantity,true);
		$criteria->compare('repair_date',$this->repair_date,true);
		$criteria->compare('repair_remarks',$this->repair_remarks,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HiringRepairHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
