<?php

/**
 * This is the model class for table "{{hiring_package_details}}".
 *
 * The followings are the available columns in table '{{hiring_package_details}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $delivery_id
 * @property integer $product_loc_hiring_id
 * @property integer $product_id
 * @property string $batch_no
 * @property string $serial_no
 * @property integer $created_by
 * @property string $created_date_time
 */
class HiringPackageDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hiring_package_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_id, delivery_id, product_loc_hiring_id, product_id', 'required'),
			array('order_id, delivery_id, product_loc_hiring_id, product_id, created_by', 'numerical', 'integerOnly'=>true),
			array('batch_no, serial_no', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, order_id, delivery_id, product_loc_hiring_id, product_id, batch_no, serial_no, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'deliveryNote' => array(self::BELONGS_TO, 'DeliveryNote', 'delivery_id'),
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),             
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'order_id' => 'Order',
			'delivery_id' => 'Delivery',
			'product_loc_hiring_id' => 'Product Loc Hiring',
			'product_id' => 'Product',
			'batch_no' => 'Batch No',
			'serial_no' => 'Serial No',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('order_id',$this->order_id);
		$criteria->compare('delivery_id',$this->delivery_id);
		$criteria->compare('product_loc_hiring_id',$this->product_loc_hiring_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('batch_no',$this->batch_no,true);
		$criteria->compare('serial_no',$this->serial_no,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HiringPackageDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getSerialNo($delivery_id=0,$product_id=0){
            $sl_no='';
            $model = self::model()->findAll(array('condition'=>'delivery_id IN ('.$delivery_id.') AND product_id='.$product_id));
            if(!empty($model)){
                foreach ($model as $each){
                    
                    if($sl_no==''){
                        $sl_no=$each->serial_no;
                    }else{
                        $sl_no.=' , '.$each->serial_no;
                    }
                }
            }	
            return $sl_no;
        }
}
