<?php

/**
 * This is the model class for table "{{hiring_operator}}".
 *
 * The followings are the available columns in table '{{hiring_operator}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $employee_id
 * @property string $start_date
 * @property string $end_date
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class HiringOperator extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hiring_operator}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
        public $min_date;
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_id, employee_id, start_date', 'required'),
			array('order_id, employee_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, order_id, employee_id, start_date, end_date, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'orderdetail' => array(self::BELONGS_TO, 'Order', 'order_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'order_id' => 'Order',
			'employee_id' => 'Employee',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'S-On Site,R-Return Site',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('order_id',$this->order_id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HiringOperator the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getOperator($order_id = 0) {
            $condition = 'employeedetail.isActive="Y"';
            if ($order_id>0) {
                $condition.=' AND order_id="'.$order_id.'"';
            }
            $model = self::model()->with('employeedetail')->findAll(array('condition' => $condition));
            $arr_employee = array();
            $employee_details = array();
            foreach ($model as $key => $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value->employeedetail->first_name, "d") . ' ' . Yii::app()->controller->ciphertext($value->employeedetail->last_name, "d")] = $value->employeedetail->id;
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['employee_id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
            return CHtml::listData($employee_details, 'employee_id', 'name');
        }
        public static function getOperatordetails($order_id) {
            $SQL ="SELECT * FROM  `erp_hr_employee`  WHERE isActive='Y'";                               
//            $SQL ="SELECT * FROM  `erp_hr_employee`  WHERE isActive='Y'  && id NOT IN (SELECT  employee_id FROM  erp_hiring_operator where order_id!='".$order_id."' AND ((start_date<='" . date('Y-m-d') ."' AND end_date>='". date('Y-m-d')."') OR (start_date<='" . date('Y-m-d') . "' AND end_date='0000-00-00')))";                               
            $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
            $employee_details = array();
            foreach ($model as$value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['employee_id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
            return CHtml::listData($employee_details, 'employee_id', 'name');
        }
        public static function getOperatordetail($start_date,$order_id) {
            if ($start_date!='0000-00-00' && $start_date!= '') {
                $start_date= date("Y-m-d", strtotime(str_replace('/', '-',$start_date)));
            }else{
                $start_date=date('Y-m-d');
            }
//            $SQL ="SELECT * FROM  `erp_hr_employee`  WHERE isActive='Y'  && id NOT IN (SELECT  employee_id FROM  erp_hiring_operator where ((order_id!='".$order_id."' AND (('". $start_date ."' BETWEEN start_date AND end_date) OR (start_date<='".$start_date."' AND end_date>='".$start_date."') OR (start_date<='".$start_date. "' AND end_date='0000-00-00') OR (start_date>='".$start_date. "'))) OR
//                (isActive='R' AND order_id='".$order_id."' AND (('". $start_date ."' BETWEEN start_date AND end_date) OR (start_date<='".$start_date."' AND end_date>='".$start_date."') OR (start_date<='".$start_date. "' AND end_date='0000-00-00') OR (start_date>='".$start_date. "'))))
//                    )";  
            $SQL ="SELECT * FROM  `erp_hr_employee`  WHERE isActive='Y'  && id NOT IN (SELECT  employee_id FROM  erp_hiring_operator where (start_date='".$start_date."' OR (start_date<='".$start_date."' AND end_date>='".$start_date."') OR (start_date<='".$start_date."' AND end_date='0000-00-00')))";             
            $model = Yii::app()->db->createCommand($SQL)->queryAll(); 
            $employee_details = array();
            foreach ($model as$value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['employee_id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
            return CHtml::listData($employee_details, 'employee_id', 'name');
        }
}
