<?php

/**
 * This is the model class for table "{{hiring_items}}".
 *
 * The followings are the available columns in table '{{hiring_items}}':
 * @property integer $id
 * @property integer $hiring_id
 * @property integer $product_id
 * @property string $part_number
 * @property string $description
 * @property string $cost_rate
 * @property string $remarks
 * @property integer $type
 * @property string $quantity
 * @property string $notes
 * @property string $sales_rate
 */
class HiringItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	 public $product_name;
	public function tableName()
	{
		return '{{hiring_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, part_number, type, quantity', 'required'),
			array('hiring_id, product_id, type', 'numerical', 'integerOnly'=>true),
			array('part_number, description', 'length', 'max'=>255),
			array('remarks', 'length', 'max'=>5000),
			array('cost_rate, quantity, sales_rate', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, hiring_id, product_id, part_number, description, cost_rate, remarks, type, quantity, notes, sales_rate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'unitdetails' =>array(self::BELONGS_TO, 'Unit', 'unit_id'),
                    'hiringdetails' =>array(self::BELONGS_TO, 'Hiring', 'hiring_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'hiring_id' => 'Hiring',
			'product_id' => 'Store',
			'part_number' => 'Part Number',
			'description' => 'Description',
			'cost_rate' => 'Cost Rate',
			'remarks' => 'Remarks',
			'type' => 'Type',
			'quantity' => 'Quantity',
			'notes' => 'Notes',
			'sales_rate' => 'Sales Rate',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('hiring_id',$this->hiring_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('cost_rate',$this->cost_rate,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('type',$this->type);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('sales_rate',$this->sales_rate,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HiringItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
