<?php

/**
 * This is the model class for table "{{hiring}}".
 *
 * The followings are the available columns in table '{{hiring}}':
 * @property integer $id
 * @property integer $product_id
 * @property string $part_number
 * @property string $description
 * @property string $cost_rate
 * @property string $remarks
 * @property integer $application_id
 * @property string $quantity
 * @property string $notes
 * @property string $sales_rate
 * @property string $received_date
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Hiring extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $unit_name;
	public $oldPartNo;
    public $oldApplicationId;
	public function tableName()
	{
		return '{{hiring}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, part_number, application_id, quantity, received_date,default_hrs_per_day', 'required'),
			array('product_id, application_id,unit_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('part_number, description', 'length', 'max'=>255),
			array('cost_rate, quantity, sales_rate', 'length', 'max'=>15),
			array('isActive', 'length', 'max'=>1),
			array('product_id','checkUniqueApplication'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, part_number, description, cost_rate, remarks, application_id, quantity, notes, sales_rate, received_date, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    
            'storedetails' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unitdetails' =>array(self::BELONGS_TO, 'Unit', 'unit_id'),
            'application' =>array(self::BELONGS_TO, 'MasHiringApplication', 'application_id'),
		);
	}
	
	public function checkUniqueApplication($attribute, $params)
    {
        if ($this->product_id !== "" && $this->application_id !== "") {
            if($this->id>0)
            $model = Hiring::model()->find('product_id = ? AND application_id = ? AND id!=?', array($this->product_id, $this->application_id,$this->id));
            else
            $model = Hiring::model()->find('product_id = ? AND application_id = ?', array($this->product_id, $this->application_id));
            if ($model != null) {
                $this->addError('id', 'This Part Number with application already exist');
            }

        }
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Store',
			'part_number' => 'Part Number',
			'description' => 'Description',
			'cost_rate' => 'Cost Rate',
			'remarks' => 'Serial No',
			'application_id' => 'Warehouse',
			'quantity' => 'Quantity',
			'notes' => 'Notes',
			'sales_rate' => 'Sales Rate',
			'received_date' => 'Received Date',
			'doc_image' => 'Document Image',
			'application_image' => 'Application Images',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('cost_rate',$this->cost_rate,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('application_id',$this->application_id);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('sales_rate',$this->sales_rate,true);
		$criteria->compare('received_date',$this->received_date,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Hiring the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
