<?php

/**
 * This is the model class for table "{{flyer_contact}}".
 *
 * The followings are the available columns in table '{{flyer_contact}}':
 * @property integer $id
 * @property integer $flyer_id
 * @property integer $contact_id
 * @property string $created_date_time
 * @property integer $created_by
 */
class FlyerContact extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{flyer_contact}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('flyer_id, contact_id, created_date_time, customer_id,created_by', 'required'),
            array('flyer_id, contact_id, customer_id,created_by', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, flyer_id, contact_id, customer_id, created_date_time, created_by', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'contractdetail' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'flyer' => array(self::BELONGS_TO, 'Flyers', 'flyer_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'flyer_id' => 'Flyer',
            'contact_id' => 'Contact',
            'created_date_time' => 'Created Date Time',
            'created_by' => 'Created By',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('flyer_id', $this->flyer_id);
        $criteria->compare('contact_id', $this->contact_id);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('created_by', $this->created_by);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FlyerContact the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
