<?php

/**
 * This is the model class for table "{{finance_emi}}".
 *
 * The followings are the available columns in table '{{finance_emi}}':
 * @property integer $id
 * @property string $reference
 * @property string $starting_date
 * @property string $name
 * @property string $amount
 * @property integer $type_id
 * @property integer $Num_of_installment
 * @property integer $current_installment
 * @property string $updated_date_time
 * @property integer $updated_by
 * @property integer $created_by
 * @property string $created_date_time
 */
class FinanceEmi extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{finance_emi}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('reference, starting_date, name, amount, type_id, Num_of_installment, current_installment, updated_date_time, updated_by, created_by, created_date_time', 'required'),
            array('type_id, Num_of_installment, current_installment, updated_by, created_by,category', 'numerical', 'integerOnly' => true),
            array('reference, name', 'length', 'max' => 500),
            array('reference, name', 'unique'),
            array('current_installment', 'validateInstallment'),
            array('amount', 'length', 'max' => 15),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, reference, starting_date, name, amount, type_id, Num_of_installment, current_installment, updated_date_time, updated_by, created_by, created_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'type' => array(self::BELONGS_TO, 'FinanceEmiType', 'type_id'),
            'installment' => array(self::HAS_MANY, 'FinanceEmiInstallment', 'emi_id'),
            'cat' => array(self::BELONGS_TO, 'EmiCategory', 'category'),
        );
    }

    public function validateInstallment() {
        if ($this->Num_of_installment < $this->current_installment) {
            $this->addError('current_installment', 'Current Installment should less than or equal to No of Installemnt');
        }
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'reference' => 'Reference',
            'starting_date' => 'Starting Date',
            'name' => 'Name',
            'amount' => 'Amount',
            'type_id' => 'Type',
            'Num_of_installment' => 'Num Of Installment',
            'current_installment' => 'Current Installment',
            'updated_date_time' => 'Updated Date Time',
            'updated_by' => 'Updated By',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('reference', $this->reference, true);
        $criteria->compare('starting_date', $this->starting_date, true);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('amount', $this->amount, true);
        $criteria->compare('type_id', $this->type_id);
        $criteria->compare('Num_of_installment', $this->Num_of_installment);
        $criteria->compare('current_installment', $this->current_installment);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FinanceEmi the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
