<?php

/**
 * This is the model class for table "{{direct_purchase_invoice_item}}".
 *
 * The followings are the available columns in table '{{direct_purchase_invoice_item}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $purchasing_invoice_id
 * @property string $description
 * @property string $quantity
 * @property string $unit
 * @property string $rate
 * @property string $amount
 * @property string $tax_percentage
 * @property string $tax_amount
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class DirectPurchaseInvoiceItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $product_name;
	public $actual_tax_percentage;
	public $actual_tax_amount;
	
	public function tableName()
	{
		return '{{direct_purchase_invoice_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, quantity,rate, amount', 'required'),
			array('product_id, purchasing_invoice_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('quantity, rate, amount, tax_percentage, tax_amount', 'length', 'max'=>15),
			array('unit,description', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, purchasing_invoice_id, description, quantity, unit, rate, amount, tax_percentage, tax_amount, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'purchasinginvoice' => array(self::BELONGS_TO, 'DirectPurchaseInvoice', 'purchasing_invoice_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'purchasing_invoice_id' => 'Purchasing Invoice',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'unit' => 'Unit',
			'rate' => 'Rate',
			'amount' => 'Amount',
			'tax_percentage' => 'Tax Percentage',
			'tax_amount' => 'Tax Amount',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('purchasing_invoice_id',$this->purchasing_invoice_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('unit',$this->unit,true);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('tax_percentage',$this->tax_percentage,true);
		$criteria->compare('tax_amount',$this->tax_amount,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DirectPurchaseInvoiceItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
