<?php

/**
 * This is the model class for table "{{direct_purchase_invoice}}".
 *
 * The followings are the available columns in table '{{direct_purchase_invoice}}':
 * @property integer $id
 * @property integer $vendor_id
 * @property string $invoice_date
 * @property string $grand_total
 * @property integer $invoice_type
 * @property string $total_tax_amount
 * @property integer $currency_id
 * @property double $exchange_rate
 * @property string $payment_terms
 * @property string $posted
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class DirectPurchaseInvoice extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{direct_purchase_invoice}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_id, invoice_date, invoice_no, payment_date', 'required'),
			array('vendor_id, invoice_type, currency_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('exchange_rate', 'numerical'),
			array('grand_total, total_tax_amount', 'length', 'max'=>15),
			array('payment_terms', 'length', 'max'=>255),
			array('posted, isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, vendor_id, invoice_date, grand_total, invoice_type, total_tax_amount, currency_id, exchange_rate, payment_terms, posted, isActive, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'invoicetype' => array(self::BELONGS_TO, 'MasInvoiceType', 'invoice_type'),
            'vendor' => array(self::BELONGS_TO, 'Company', 'vendor_id'),
            'vendor_details' => array(self::BELONGS_TO, 'Vendor', 'vendor_id'),
            'items' => array(self::HAS_MANY, 'PurchasingInvoiceItem', 'purchasing_invoice_id'),
            'adItems' => array(self::HAS_MANY, 'PurchasingInvoiceAddition', 'purchasing_invoice_id'),
            'dedItems' => array(self::HAS_MANY, 'PurchasingInvoiceDeduction', 'purchasing_invoice_id'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'shippedby' => array(self::BELONGS_TO, 'MasShipping', 'shipped_by'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms'),
            'createdby' => array(self::BELONGS_TO, 'User', 'created_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'vendor_id' => 'Vendor',
			'invoice_date' => 'Invoice Date',
			'grand_total' => 'Grand Total',
			'invoice_type' => 'Invoice Type',
			'total_tax_amount' => 'Total Tax Amount',
			'currency_id' => 'Currency',
			'exchange_rate' => 'Exchange Rate',
			'payment_terms' => 'Payment Terms',
			'posted' => 'Posted',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('vendor_id',$this->vendor_id);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('grand_total',$this->grand_total,true);
		$criteria->compare('invoice_type',$this->invoice_type);
		$criteria->compare('total_tax_amount',$this->total_tax_amount,true);
		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('exchange_rate',$this->exchange_rate);
		$criteria->compare('payment_terms',$this->payment_terms,true);
		$criteria->compare('posted',$this->posted,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DirectPurchaseInvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
