<?php

/**
 * This is the model class for table "{{direct_invoice}}".
 *
 * The followings are the available columns in table '{{direct_invoice}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $contact_id
 * @property integer $lead_owner_id
 * @property string $invoice_date
 * @property integer $sales_group_id
 * @property string $reference
 * @property string $grand_total
 * @property integer $invoice_type
 * @property string $total_tax_amount
 * @property integer $currency_id
 * @property double $exchange_rate
 * @property string $payment_terms
 * @property string $posted
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class DirectInvoice extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $customer_name; 
	public $contact_name;
	public function tableName()
	{
		return '{{direct_invoice}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		    array('customer_id, contact_id, lead_owner_id,invoice_date, currency_id, exchange_rate,invoice_type', 'required'),
			array('customer_id, contact_id, lead_owner_id, sales_group_id, invoice_type, currency_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('exchange_rate', 'numerical'),
			array('terms_and_conditions', 'length', 'max'=>5000),
			array('reference, payment_terms,remarks', 'length', 'max'=>255),
			array('grand_total, total_tax_amount', 'length', 'max'=>15),
			array('posted, isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, contact_id, lead_owner_id, invoice_date, sales_group_id, reference, grand_total, invoice_type, total_tax_amount, currency_id, exchange_rate, payment_terms, posted, isActive, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'currency_details' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'customer_details' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'contact_details' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'netAmount' => array(self::STAT, 'DirectInvoiceItem', 'order_id', 'select' => 'SUM(amount)'),
            'netVat' => array(self::STAT, 'DirectInvoiceItem', 'order_id', 'select' => 'SUM(tax_amount)'),
            'adItems' => array(self::HAS_MANY, 'DirectInvoiceAddition', 'order_id'),
			'dedItems' => array(self::HAS_MANY, 'DirectInvoiceDeduction', 'order_id'),
			'invoicetype' => array(self::BELONGS_TO, 'MasInvoiceType', 'invoice_type'),
			'user' => array(self::BELONGS_TO, 'User', 'created_by'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms'),
            'invoicestatus' => array(self::BELONGS_TO, 'MasInvoiceStatus', 'invoice_status'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'contact_id' => 'Contact',
			'lead_owner_id' => 'Lead Owner',
			'invoice_date' => 'Invoice Date',
			'sales_group_id' => 'Sales Group',
			'reference' => 'Reference',
			'grand_total' => 'Grand Total',
			'invoice_type' => 'Invoice Type',
			'total_tax_amount' => 'Total Tax Amount',
			'currency_id' => 'Currency',
			'exchange_rate' => 'Exchange Rate',
			'payment_terms' => 'Payment Terms',
			'posted' => 'Posted',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('contact_id',$this->contact_id);
		$criteria->compare('lead_owner_id',$this->lead_owner_id);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('sales_group_id',$this->sales_group_id);
		$criteria->compare('reference',$this->reference,true);
		$criteria->compare('grand_total',$this->grand_total,true);
		$criteria->compare('invoice_type',$this->invoice_type);
		$criteria->compare('total_tax_amount',$this->total_tax_amount,true);
		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('exchange_rate',$this->exchange_rate);
		$criteria->compare('payment_terms',$this->payment_terms,true);
		$criteria->compare('posted',$this->posted,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DirectInvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
