<?php
/**
 * This is the model class for table "{{delivery_components}}".
 *
 * The followings are the available columns in table '{{delivery_components}}':
 * @property integer $id
 * @property integer $delivery_note_id
 * @property integer $order_item_id
 * @property integer $product_id
 * @property string $description
 * @property string $quantity
 * @property integer $unit_id
 * @property string $picked_qty
 * @property string $remarks
 * @property string $inventory_type
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class DeliveryComponents extends CActiveRecord
{
    public $product_name;
    public $unit_name;
    public $factor;
    public $pickable_quantity;
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{delivery_components}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('delivery_note_id, order_item_id, product_id, description, quantity, unit_id, picked_qty, inventory_type, ', 'required'),
            array('delivery_note_id, order_item_id, product_id, unit_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
            array('quantity, picked_qty', 'length', 'max'=>15),
            array('inventory_type', 'length', 'max'=>1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, delivery_note_id, order_item_id, product_id, description, quantity, unit_id, picked_qty, remarks, inventory_type, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'deliveryNote' => array(self::BELONGS_TO, 'DeliveryNote', 'delivery_note_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),            
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
            'orderitem' => array(self::BELONGS_TO, 'OrderComponents', 'order_item_id'),    
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'delivery_note_id' => 'Delivery Note',
            'order_item_id' => 'Order Item',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit_id' => 'Unit',
            'picked_qty' => 'Picked Qty',
            'remarks' => 'Remarks',
            'inventory_type' => 'Inventory Type',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_datetime' => 'Created Datetime',
            'updated_datetime' => 'Updated Datetime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('delivery_note_id',$this->delivery_note_id);
        $criteria->compare('order_item_id',$this->order_item_id);
        $criteria->compare('product_id',$this->product_id);
        $criteria->compare('description',$this->description,true);
        $criteria->compare('quantity',$this->quantity,true);
        $criteria->compare('unit_id',$this->unit_id);
        $criteria->compare('picked_qty',$this->picked_qty,true);
        $criteria->compare('remarks',$this->remarks,true);
        $criteria->compare('inventory_type',$this->inventory_type,true);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('updated_by',$this->updated_by);
        $criteria->compare('created_datetime',$this->created_datetime,true);
        $criteria->compare('updated_datetime',$this->updated_datetime,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return DeliveryComponents the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}
