<?php

class DateModel
{

    public static function toSqlDate($str)
    {
        $date = "";
        $date_array = explode("/", $str);
        if (!empty($date_array) && count($date_array) > 2) {
            $date = "{$date_array[2]}-{$date_array[1]}-{$date_array[0]}";
        }
        return trim($date);
    }

    public static function toSqlDateTime($str)
    {
        $array = explode(" ", $str);
        $date_array = explode("/", $array[0]);
        $date = "";
        if (!empty($date_array)) {
            $date = "{$date_array[2]}-{$date_array[1]}-{$date_array[0]} " . $array[1];
        }
        return $date;
    }

    public static function diffInDays($date1, $date2)
    {
        $days = (strtotime($date2) - strtotime($date1)) / (60 * 60 * 24);
        return $days;
    }

    public static function addDays($date, $days)
    {
        $day = (int) $days;
        return date('Y-m-d', strtotime($date . "+ {$day} days"));
    }

    public static function displayDate($date, $nullAstoday = true)
    {
        $display_date = "";
        if ($date == '0000-00-00' || $date == "") {
            if ($nullAstoday) {
                $display_date = date("d/m/Y");
            }
        } else {
            $display_date = date("d/m/Y", strtotime($date));
        }
        return $display_date;
    }

    public static function displayDateTime($date)
    {
        $display_date = "";
        if ($date == '0000-00-00 00:00:00' || $date == "") {

        } else {
            $display_date = date("d/m/Y H:i:s", strtotime($date));
        }
        return $display_date;
    }

    public static function displayDateorEmpty($date)
    {
        $display_date = "";
        if ($date == '0000-00-00' || $date == "") {
            $display_date = "";
        } else {
            $display_date = date("d/m/Y", strtotime($date));
        }
        return $display_date;
    }
    public static function compareDate($date)
    {
        $date_now = date("Y-m-d", strtotime("+30 days", strtotime(date('Y-m-d'))));
        $date_now = strtotime($date_now);
        $date_convert = strtotime($date);

        if ($date_now >= $date_convert) {
            $comval = '1';
        } else {
            $comval = '0';
        }
        return $comval;
    }
    public static function compare3Dates($date)
    {
        $date_now = date("Y-m-d", strtotime("+3 days", strtotime(date('Y-m-d'))));
        $date_now = strtotime($date_now);
        $date_convert = strtotime($date);

        if ($date_now >= $date_convert) {
            $comval = '1';
        } else {
            $comval = '0';
        }
        return $comval;
    }

}
