<?php


class CustomerTemp extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        
        
        public function tableName()
	{
		return '{{customer_temp}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
		
            array('customer_name, customer_address, customer_city, customer_postal_code,customer_state, 
                    customer_country, customer_phone_no, customer_email_id, customer_location, customer_fax, 
                    customer_web, customer_industry, customer_shipping_address
                    ,customer_shipping_city,customer_shipping_postal_code,customer_shipping_state,customer_shipping_country', 'length', 'max'=>255),
                      
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id,company_id, customer_name, customer_address, customer_city, customer_postal_code,customer_state, 
                    customer_country, customer_phone_no, customer_email_id, customer_location, customer_fax, 
                    customer_web, customer_industry, created_datetime, created_by, updated_datetime, updated_by,customer_shipping_address
                    ,customer_shipping_city,customer_shipping_postal_code,customer_shipping_state,customer_shipping_country', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                  'country' => array(self::BELONGS_TO, 'MasCountry','customer_country'),  
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' =>'Company Id',
			'customer_name' => 'Customer ',
		//	'customer_credit_limit' => 'Limit',
			//'customer_currency_id' => 'Currency',
			'customer_address' => 'Address',
                        
			'customer_city' => 'City',
			'customer_postal_code' => 'Postal Code',
			'customer_state' => 'State',
			'customer_country' => 'Country',
                        'customer_shipping_address' =>'Shipping address',
                        'customer_shipping_city' => 'customer_shipping_city',
                        'customer_shipping_postal_code' => 'Shipping postal code',
                        'customer_shipping_state' => 'Shipping State',
                        'customer_shipping_country' => 'customer shipping country',
                        //'sales_pricing_group' => 'sales pricing group',
                        //'customer_pin_zip' => 'Zip Code',
			
			'customer_phone_no' => 'Phone No',
			'customer_email_id' => 'Email',
			'customer_location' => 'Location',
			//'customer_payment_term' => ' Payment Term',
			'customer_fax' => ' Fax',
			'customer_web' => 'Web',
			'customer_industry' => 'Industry',
			'customer_trn_no' => 'TRN#',
			//'is_approved' => 'Is Approved',
			//'isActive' => 'Is Active',
            'created_datetime' => 'Created Date',
			'created_by' => 'Created By',
			'updated_datetime' => 'Updated Date',
			'updated_by' => 'Updated By',
                        
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
     
     public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

       
}
