<?php

/**
 * This is the model class for table "{{customer_shipping_details}}".
 *
 * The followings are the available columns in table '{{customer_shipping_details}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $shipping_customer_name
 * @property string $state
 * @property string $city
 * @property string $street_address
 * @property string $po_box
 * @property string $postal_code
 * @property integer $country_id
 */
class CustomerShippingDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{customer_shipping_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('id, customer_id, shipping_customer_name, state, city, street_address, po_box, postal_code, country_id', 'required'),
			array('id, customer_id, country_id', 'numerical', 'integerOnly'=>true),
			array('shipping_customer_name, state, city, po_box, postal_code', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, shipping_customer_name, state, city, street_address, po_box, postal_code, country_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'country' => array(self::BELONGS_TO, 'MasCountry','country_id'),
                    
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'shipping_customer_name' => 'Shipping Customer Name',
			'state' => 'State',
			'city' => 'City',
			'street_address' => 'Street Address',
			'po_box' => 'Po Box',
			'postal_code' => 'Postal Code',
			'country_id' => 'Country',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('shipping_customer_name',$this->shipping_customer_name,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('street_address',$this->street_address,true);
		$criteria->compare('po_box',$this->po_box,true);
		$criteria->compare('postal_code',$this->postal_code,true);
		$criteria->compare('country_id',$this->country_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerShippingDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
    public static function getCity($id) {

        $shippingDetails = CustomerShippingDetails::model()->findAll([
            'condition' => 'customer_id = :id',
            'params' => [':id' => $id],
            'order' => 'id DESC',
        ]);
        
        $cities = array();
        foreach ($shippingDetails as $customer) {
            if( !empty($customer->city)){
                $cities[$customer->id] = $customer->city;
            }
            
        }

        return $cities;
    }


}
