<?php

/**
 * This is the model class for table "{{customer_outlet_location}}".
 *
 * The followings are the available columns in table '{{customer_outlet_location}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $shipping_customer_name
 * @property integer $outlet_location
 */
class CustomerOutletLocation extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{customer_outlet_location}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('customer_id, shipping_customer_name', 'required'), // required fields
			array('customer_id', 'numerical', 'integerOnly' => true),
			array('shipping_customer_name', 'length', 'max' => 255),
			array('outlet_location', 'safe'), // allow textarea input
			array('id, customer_id, shipping_customer_name, outlet_location', 'safe', 'on' => 'search'),
		);
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'shipping_customer_name' => 'Shipping Customer Name',
			'outlet_location' => 'Outlet Location',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('customer_id', $this->customer_id);
		$criteria->compare('shipping_customer_name', $this->shipping_customer_name, true);
		$criteria->compare('outlet_location', $this->outlet_location);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerOutletLocation the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	public static function getOutlet($cust_id = 0)
	{
		// var_dump($cust_id);
		$condition = '1=1 ';
		if ($cust_id > 0) {
			$condition .= 'AND customer_id=cust_id' . $cust_id;
		}
		$model = self::model()->findAllByAttributes(['customer_id' => $cust_id], ['order' => 'id DESC']);
		return CHtml::listData($model, 'id', 'outlet_location');

	}

	public static function getShippingLocation($customer_id)
	{
		$response = array();
		if ($customer_id > 0) {
			$condition = 'customer_id =  ' . $customer_id . '';
			$model = self::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
			$response = CHtml::listData($model, 'id', 'outlet_location');
		}
		return $response;
	}

	public static function getShippingLocationById($id)
	{
		$response = array();
		if ($id > 0) {
			$condition = 'id =  ' . $id . '';
			$model = self::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
			$response = CHtml::listData($model, 'id', 'outlet_location');
		}
		return $response;
	}




}
