<?php

/**
 * This is the model class for table "{{customer_dashboard}}".
 *
 * The followings are the available columns in table '{{customer_dashboard}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $ai_dashboard_id
 * @property string $customer_value
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class CustomerDashboard extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $ai_dashboard_name;
	
	public function tableName()
	{
		return '{{customer_dashboard}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, ai_dashboard_id, customer_value', 'required'),
			array('customer_id, ai_dashboard_id, updated_by', 'numerical', 'integerOnly'=>true),
			array('customer_value', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, ai_dashboard_id, customer_value, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'ai_dashboard_id' => 'Ai Dashboard',
			'customer_value' => 'Customer Value',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('ai_dashboard_id',$this->ai_dashboard_id);
		$criteria->compare('customer_value',$this->customer_value,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerDashboard the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
