<?php

/**
 * This is the model class for table "{{color_settings}}".
 *
 * The followings are the available columns in table '{{color_settings}}':
 * @property integer $id
 * @property integer $company_id
 * @property string $theme_color
 * @property string $light_color
 * @property string $icon_color
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $table_header_color
 * @property string $logo_bg_color
 * @property string $side_menu_color
 * @property string $popup_header_color
 */
class ColorSettings extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{color_settings}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, theme_color, light_color, logo_bg_color, side_menu_color, popup_header_color', 'required'),
			array('company_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('theme_color, light_color, logo_bg_color,print_tbl_border_color,print_tbl_header_color,print_top_left_bg,print_footer_bg,login_page_bg,grid_header_font_color,grid_table_bg,grid_table_row_color,print_top_left_box_text_color,print_table_alternative_row_bg ,button_color,menu_color,menu_hover_color,dashboard_count_color,theme_color_right,light_color_right,tab_bg_color,graph_color_one,graph_color_two,graph_color_three,graph_color_four,graph_color_five,graph_color_six,graph_color_seven,graph_color_eight', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, theme_color, light_color, created_by, created_date_time, updated_by, updated_date_time, logo_bg_color', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'theme_color' => 'Theme Color',
			'light_color' => 'Button Color',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			 'logo_bg_color' => 'Logo Bg Color',
		 );
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('theme_color',$this->theme_color,true);
		$criteria->compare('light_color',$this->light_color,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('logo_bg_color',$this->logo_bg_color,true);
		
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ColorSettings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
