<?php

/**
 * This is the model class for table "{{cheque_collection}}".
 *
 * The followings are the available columns in table '{{cheque_collection}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $location_id
 * @property string $date_of_collection
 * @property integer $cheque_amount
 * @property string $notes
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class ChequeCollection extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cheque_collection}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, location_id', 'required'),
			array('customer_id, location_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('notes', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, location_id, date_of_collection, cheque_amount, notes, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'location' => array(self::BELONGS_TO, 'MasLocation','location_id'),
			'customer' => array(self::BELONGS_TO, 'Customer','customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'location_id' => 'Location',
			'date_of_collection' => 'Date Of Collection',
			'cheque_amount' => 'Cheque Amount',
			'notes' => 'Notes',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('location_id',$this->location_id);
		$criteria->compare('date_of_collection',$this->date_of_collection,true);
		$criteria->compare('cheque_amount',$this->cheque_amount);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ChequeCollection the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getStatus(){
        $condition = '1=1';
        $model = self::model()->findAll(array('select' => 'status','condition' => $condition));
        return CHtml::listData($model, 'status', 'status');

	}
}
