<?php

/**
 * This is the model class for table "view_packaging_list".
 *
 * The followings are the available columns in table 'view_packaging_list':
 * @property integer $transaction_id
 * @property string $file_id
 * @property string $transaction_date
 * @property string $customer_id
 * @property string $customer_name
 * @property string $packing_frm
 * @property string $status
 */
class CheckinList extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'view_checkin_list';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('transaction_id', 'numerical', 'integerOnly'=>true),
			array('file_id', 'length', 'max'=>11),
			array('customer_id', 'length', 'max'=>20),
			array('customer_name', 'length', 'max'=>255),
			array('packing_frm', 'length', 'max'=>13),
			array('status', 'length', 'max'=>2),
			array('transaction_date', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('transaction_id, file_id, transaction_date, customer_id, customer_name, packing_frm, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'credit_details'=>array(self::BELONGS_TO, 'Creditnote', 'transaction_id', 'condition' => 't.status="CN"')
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'transaction_id' => 'Transaction',
			'file_id' => 'File',
			'transaction_date' => 'Transaction Date',
			'customer_id' => 'Customer',
			'customer_name' => 'Customer Name',
			'packing_frm' => 'Packing Frm',
			'status' => 'Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('transaction_id',$this->transaction_id);
		$criteria->compare('file_id',$this->file_id,true);
		$criteria->compare('transaction_date',$this->transaction_date,true);
		$criteria->compare('customer_id',$this->customer_id,true);
		$criteria->compare('customer_name',$this->customer_name,true);
		$criteria->compare('packing_frm',$this->packing_frm,true);
		$criteria->compare('status',$this->status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PackagingList the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
