
application/x-httpd-php Assignments.php ( PHP script text )
<?php

/**
 * This is the model class for table "{{assignments}}".
 *
 * The followings are the available columns in table '{{assignments}}':
 * @property integer $id
 * @property string $date
 * @property integer $customer_id
 * @property integer $user_id
 * @property string $remarks
 * @property string $isComplete
 * @property integer $created_by
 * @property string $created_datetime
 */
class Assignments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $customer_name;

	public function tableName()
	{
		return '{{activity}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, customer_id, type, user_id, remarks, isComplete, created_by, created_datetime', 'required'),
			array('customer_id, user_id, created_by', 'numerical', 'integerOnly'=>true),
			array('isComplete', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, date, customer_id, user_id, remarks, isComplete, created_by, created_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'createdUser' => array(self::BELONGS_TO, 'User', 'created_by'),
			'assignedUser' => array(self::BELONGS_TO, 'User', 'user_id'),
			'customerDetails' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'date' => 'Date',
			'customer_id' => 'Customer',
			'user_id' => 'User',
			'remarks' => 'Remarks',
			'isComplete' => 'Is Complete',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('date',$this->date,true);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('isComplete',$this->isComplete,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Assignments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}