<?php

/**
 * This is the model class for table "{{approval_level_details}}".
 *
 * The followings are the available columns in table '{{approval_level_details}}':
 * @property integer $id
 * @property integer $approval_level_id
 * @property integer $level1_user_id
 * @property string $level1_amount
 * @property integer $level2_user_id
 * @property string $level2_amount
 * @property integer $level3_user_id
 * @property string $level3_amount
 */
class ApprovalLevelDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{approval_level_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('approval_level_id, level1_user_id, level1_amount, level2_user_id, level2_amount, level3_user_id, level3_amount', 'required'),
			array('approval_level_id, level1_user_id, level2_user_id, level3_user_id', 'numerical', 'integerOnly'=>true),
			array('level1_amount, level2_amount, level3_amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, approval_level_id, level1_user_id, level1_amount, level2_user_id, level2_amount, level3_user_id, level3_amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'approval_level_id' => 'Approval Level',
			'level1_user_id' => 'Level1 User',
			'level1_amount' => 'Level1 Amount',
			'level2_user_id' => 'Level2 User',
			'level2_amount' => 'Level2 Amount',
			'level3_user_id' => 'Level3 User',
			'level3_amount' => 'Level3 Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('approval_level_id',$this->approval_level_id);
		$criteria->compare('level1_user_id',$this->level1_user_id);
		$criteria->compare('level1_amount',$this->level1_amount,true);
		$criteria->compare('level2_user_id',$this->level2_user_id);
		$criteria->compare('level2_amount',$this->level2_amount,true);
		$criteria->compare('level3_user_id',$this->level3_user_id);
		$criteria->compare('level3_amount',$this->level3_amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ApprovalLevelDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
