<?php

/**
 * This is the model class for table "{{application_images}}".
 *
 * The followings are the available columns in table '{{application_images}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $application_id
 * @property string $application_images
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ApplicationImages extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{application_images}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, application_id, application_images', 'required'),
			array('product_id, application_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, application_id, application_images, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'application_id' => 'Application',
			'application_images' => 'Application Images',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('application_id',$this->application_id);
		$criteria->compare('application_images',$this->application_images,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ApplicationImages the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
    public static function getHiringApplication($product_id=0,$application_id=0) {
        $condition = 'isActive =  "Y"';
        $application_image=array();
        $model_application_img = ApplicationImages::model()->findAll(array('select'=>'application_id','condition' => 'application_id!="'.$application_id.'" and product_id="'.$product_id.'"'));
        foreach ($model_application_img as $key_1 => $value_1) {
            $application_image[$key_1]=$value_1->application_id;
        }
        $model = MasHiringApplication::model()->findAll(array('condition' => $condition,'order'=>'application_name asc'));
        $applications=array();
        foreach ($model as $key => $value) {
            if (!in_array($value->id,$application_image)) {
                $applications[$key]['id']=$value->id;
                $applications[$key]['application_name']=$value->application_name;
            }
        }
        return CHtml::listData($applications, 'id', 'application_name');
    }
}
