<?php

/**
 * Description of AppAuthentication
 *
 * @author Manu
 */
class AppAuthentication {

    public $user = null;
    public $customer = null;
    public $logined_user_type = "";

    const TYPE_CUSTOMER = "C";
    const TYPE_USER = "U";

    private $_http_token;

    public function __construct($http_token = null) {
        $this->_http_token = trim($http_token);
    }

    public function loginUser() {
        $user = new User();
        $this->user = $user->findBytoken($this->_http_token);
        if (!empty($this->user->id) && $this->user->isActive == "Y") {
            $this->logined_user_type = self::TYPE_USER;
            return true;
        } else {
            $this->user = null;
            return false;
        }
    }

    public function loginCustomer() {
        $customer = new Customer();
        $this->customer = $customer->findBytoken($this->_http_token);
        if (empty($this->customer)) {
            return false;
        } else {
            $this->logined_user_type = self::TYPE_CUSTOMER;
            return true;
        }
    }

    public function login() {
        return $this->loginCustomer() || $this->loginUser();
    }

}
