<?php

/**
 * This is the model class for table "{{allocated_materials}}".
 *
 * The followings are the available columns in table '{{allocated_materials}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $file_id
 * @property integer $count
 * @property string $allocation_date
 * @property string $allocated_from
 *
 * The followings are the available model relations:
 * @property MasterFile $file
 * @property Store $product
 */
class AllocatedMaterial extends CActiveRecord {

    public $sum_of_count;
    public $sum_of_total_value;
    public $file_for_materialallocation;
    public $product_for_materialallocation;
    public $company_id;
    public $customer_for_materialallocation;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{allocated_materials}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, file_id, quantity, allocation_date, allocated_from, allocation_end_date,header_id', 'required'),
            array('product_id, file_id, quantity', 'numerical', 'integerOnly' => true),
            array('allocated_from', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, product_id, file_id, quantity, allocation_date, allocated_from', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_id' => 'Product',
            'file_id' => 'File',
            'quantity' => 'Quantity',
            'allocation_date' => 'Allocation Date',
            'allocated_from' => 'Allocated From',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $criteria->addCondition('t.quantity>0', 'AND');
        if (isset($_POST['product_id']))
            $criteria->addCondition('t.product_id = "' . $_POST['product_id'] . '"', 'AND');
        if (isset($_POST['fileno']))
            $criteria->addCondition('t.file_id = "' . $_POST['fileno'] . '"', 'AND');
        if (isset($_POST['allocationendmonth'])) {
            $criteria->addCondition("YEAR(allocation_end_date)='" . date('Y') . "' AND MONTH(allocation_end_date) ='" . date('m', strtotime($_POST['allocationendmonth'])) . "' AND quantity>0", 'AND');
        }

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id,t.product_id,t.file_id,t.quantity',
            ),
            'pagination' => array('pageSize' => 10)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AllocatedMaterials the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getfileid() {
        // $condition = 'isActive =  "Y"';
        $model = self::model()->findAll();
        return CHtml::listData($model, 'file_id', 'file_id');
    }

    public function getproductpartno() {

        $model = AllocatedMaterial::model()->with('product')->findAll();
        return CHtml::listData($model, 'product_id', 'product.part_number');
    }

    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(quantity) FROM `crm_allocated_materials` where id in ($ids)");
        return $command->queryScalar();
    }

    public function renderQuantityOrdered($data, $row) {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(quantity) FROM 
            {{order_item}} AS orderitem 
            INNER JOIN 
            {{order}} AS order0
            INNER JOIN 
            {{master_file}} AS file
            ON 
            orderitem.order_id=order0.id AND order0.file_id=file.id 
            where product_id=" . $data->product_id . ' AND file.id=' . $data->file_id);
        return $command->queryScalar();
    }

    public function renderFreeQuantity($data, $row) {
        /* $connection = Yii::app()->db;
          $command = $connection->createCommand("SELECT SUM(quantity) FROM
          {{order_item}} AS orderitem
          INNER JOIN
          {{order}} AS order0
          INNER JOIN
          {{master_file}} AS file
          ON
          orderitem.order_id=order0.id AND order0.file_id=file.id
          where product_id=" . $data->product_id . ' AND file.id=' . $data->file->id);
          return $command->queryScalar(); */
        $total_qty = $data->product->total_quantity;
        $allocated_qty = $data->product->total_allocated_quantity;
        return ($total_qty - $allocated_qty);
    }

    public function renderQuantityToBePurchased($data, $row) {
        $total_qty = $data->product->total_quantity;
        $allocated_qty = $data->product->total_allocated_quantity;
        $freeQty = ($total_qty - $allocated_qty);
        $qtyToBePrchsd = $this->renderQuantityOrdered($data, $row) - $data->quantity - $freeQty;
        if ($qtyToBePrchsd > 0)
            return abs($qtyToBePrchsd);
        else
            return 0;
    }

//         public function to_be_purchased_totals($productids){
//                $productids = implode(",",$productids);                
//                $connection=Yii::app()->db;
//                $command=$connection->createCommand("SELECT SUM(quantity) FROM `crm_allocated_materials` where id in ($productids)");                                                                                        
//                return "Total ".$amount = $command->queryScalar(); 
//             
//         }
}
