<?php

class UsersController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'Create', 'GetList', 'SaveUsers', 'DeleteUsers', 'SalesMaster', 'GetSalesList', 'Target', 'SaveTarget', 'UploadSignature', 'PrintUsersPdf',
                    'BlockUser', 'CreateAccessibleBranch', 'SaveMisAccessibleBranches',
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

   public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['admin_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['admin_users_view']) &&
            Yii::app()->user->havePermissionOn['admin_menu_view'] && 
            Yii::app()->user->havePermissionOn['admin_users_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }
    public function actionGetList() {
        $model = new User();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'username',
            1 => 'first_name',
            2 => 'level',
            3 => 'warehouse.warehouse_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        //$condition = 't.level!=0 AND t.isActive="Y" ';
        $condition = 't.isActive="Y" AND t.level > 0 AND t.level!=2 AND company_id=' . Yii::app()->user->master_user_company_id;
        if (isset($_POST['display_type']) && $_POST['display_type'] == 2) {

            $condition = 't.isActive="Y" AND t.level!=0 AND company_id=' . Yii::app()->user->master_user_company_id;
        }
        if ($_POST['warehouse_id'] != '') {
            $condition .= ' AND t.available_warehouses="' . $_POST['warehouse_id'] . '"';
        }
        if ($_POST['level'] != '') {
            $condition .= ' AND t.level="' . $_POST['level'] . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {


            $searchString = $_POST['search']['value'];

            $condition .= " and (username LIKE '%" . $searchString . "%' OR first_name LIKE '%" . $searchString . "%'
                  OR level LIKE '%" . $searchString . "%'

                  OR warehouse.warehouse_name LIKE '%" . $searchString . "%')";
        }


        if (Yii::app()->user->level > 1) {
            $condition .= ' AND available_warehouses=' . (int) Yii::app()->user->user_warehouse_id;
        }

        /* else{
          $condition.=" AND t.level=1";
          } */

        /* */

        $count = $model->with('warehouse')->count(array('condition' => $condition));
        $model = $model->with('warehouse')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'username'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {


            if ($row['level'] == '1') {
                $level = 'Admin';
            } else if ($row['level'] == '3') {
                $level = 'Branch';
            } else if ($row['level'] == '4') {
                $level = 'Sales';
            } else {
                $level = '';
            }

            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_users_edit"])) {
                //  $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'users/create&id='.$row['id'].'\',\'Users\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            //                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_users_delete"])){
            //                        $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteUsers('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            //                    }
            $rowData[] = array(
                $m,
                $row['staff_id'],
                $row['first_name'] . " " . $row['last_name'],
                $row['username'],
                $level,
                $row->warehouse->warehouse_name,
                $row->userGroup->group_name,
                array('id' => $row['id'], 'code' => $row['username'], 'level' => $row['level'], 'active' => $row['isActive'])
            );

            $m++;
        }


        //                foreach ($model as $row)
        //                {
        //                    $rowData[]=array($m,$row['username'],$row['first_name']." ".$row['last_name'],$row['designation'],$row->userGroup->group_name,'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'users/create&id='.$row['id'].'\',\'Users\',\'lg\')"><i class="fa fa-pencil"></i></button> '
        //             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUsers('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
        //                    $m++;
        //                }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new User();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('users_form', array('model' => $model), false, false);
    }

    public function actionSaveUsers() {
        $model = new User();
        if (isset($_POST['User'])) {
            if ((int) @$_POST['User']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['User']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['User'];
            $model->is_lead_owner = $_POST['User']['is_lead_owner'];
            $model->signature = $_POST['User']['signature'];
            $model->commission = $_POST['User']['commission'];
            $model->technician_id = $_POST['User']['technician_id'];
            // $model->level='1';
            if (isset($_POST['User']['branch_id']) && $_POST['User']['branch_id'] != '') {
                $model->branch_id = implode(',', $_POST['User']['branch_id']);
            } else {
                $model->branch_id = "";
            }
            if (!empty($_POST['User']['available_warehouses'])) {
                //  $model->available_warehouses=  implode(',', $_POST['User']['available_warehouses']);
                $model->available_warehouses = $_POST['User']['available_warehouses'];
            }
            //code added sarika on 3-11-2022
            /*   if(!empty($_POST['User']['location_id'])){
              $model->location_id=  implode(',', $_POST['User']['location_id']);
              } */
            //end code
            //$company=MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
            $model->company_id = Yii::app()->user->master_user_company_id;
            if ($model->save()) {


                // -----------------------------------------------------------------------------------------------------------
                //save this  Employee user to Accounts Subledgder---added- by-indhu-15-1-2023
                //------------------------------------------------------------------------------------------------------------
                $username = $model->first_name . " " . $model->last_name;

                $modelAccSubledger = new AccSubledger();
                $type = "E";
                $modelAccSubledger->saveEachSubledgder($model->id, $username, $type);
                // -----------------------------------------------------------------------------------------------------------
                //-----------------------------------end-------------------------------------------------------------------------
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'USER', Yii::app()->user->id, $audit_type, " with username: - {$model->username}/{$model->id}  ", "", ""
                );
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['users_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteUsers() {
        $id = $_POST['id'];
        $model = new User();
        $model->deleteByPk($id);
        echo "success";
    }

    public function actionGetSalesList() {
        $model = new User();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
           
            0 => 'username',
            1 => 'first_name',
            2 => 'designation',
            3 => 'user_group_id',
            4 => 't.id',
            5 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "userGroup.group_name LIKE '%sale%'  ";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and ( username LIKE '%" . $searchString . "%' OR first_name LIKE '%" . $searchString . "%' OR designation LIKE '%" . $searchString . "%' OR user_group_id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('userGroup')->count(array('condition' => $condition));
        $model = $model->with('userGroup')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        //$model = User::getUserFromSalesGroup($condition, $orderBy, $limit, $offset);
        //$count = count(User::getCountUserFromSalesGroup($condition));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_users_edit"])) {
                $div = ' <button class="btn btn-primary btn-xs" title="Sales Target" onclick="loadPopupModal(\'salestarget/create&id=' . $row['id'] . '\',\'Sales Target - ' . $row['first_name'] . ' ' . $row['last_name'] . ' \',\'xl\')"><i class="fa fa-history"></i></button>';
                $div .= ' <button class="btn btn-primary btn-xs" title="Activity Target" onclick="loadPopupModal(\'users/target&id=' . $row['id'] . '\',\'Activity Target - ' . $row['first_name'] . ' ' . $row['last_name'] . ' \',\'lg\')"><i class="fa fa-tag"></i></button>';
            }
            $rowData[] = array(
                $m,
                $row['username'],
                $row['first_name'] . " " . $row['last_name'],
                $row['designation'],
                $row->userGroup->group_name,
                '<div class="btn-wrap text-center">' . $div . '</div>'
            );

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionTarget() {
        $user_id = Yii::app()->request->getParam('id');
        $model = new SalesManTarget;
        if ($user_id > 0) {
            $model = $model->findAll(array('condition' => 'user_id = ' . $user_id . ' '));
        } else {
            $model = array(new SalesManTarget);
        }
        $targetContents = ProspectsActivityMaster::model()->findAll(array('condition' => 'isActive = "Y" '));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('target_form', array('model' => $model, 'targetContents' => $targetContents, 'user_id' => $user_id));
    }

    public function actionSaveTarget() {
        SalesManTarget::model()->deleteAll('user_id=:refer_id', array(':refer_id' => $_POST['SalesManTarget'][0]['user_id']));
        if (is_array($_POST['SalesManTarget'])) {
            foreach ($_POST['SalesManTarget'] as $item) {

                $model = new SalesManTarget();
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d h:i:s');
                $model->user_id = $item['user_id'];
                $model->target_type = $item['target_type'];
                $model->target_master_id = $item['target_master_id'];
                $model->target_daily = $item['target_daily'];
                $model->target_weekly = $item['target_weekly'];
                $model->target_monthly = $item['target_monthly'];
                $model->target_quarterly = $item['target_quarterly'];
                $model->target_yearly = $item['target_yearly'];
                $model->save(false);
            }
        }
        // inserting to audit log
        $user = new User();
        AuditLog::saveAuditLogs(
                'SALES_TARGET', Yii::app()->user->id, 'UPDATED', " for username : - " . $user->findByPk($_POST['SalesManTarget'][0]['user_id'])->username
        );
        // end audit log
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionSalesMaster() {
        $this->render('sales_list');
    }

    public function actionUploadSignature($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array();
        $sizeLimit = 1 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropuploadImage($folder, $fileName);
        echo $return; // it's array
    }

    function CropuploadImage($folder, $fileName) {
        $imagefile = getimagesize($folder . $fileName);
        if (is_array($imagefile)) {
            $width = 150;
            $height = 200;
            $thumb = Yii::app()->phpThumb->create($folder . '/' . $fileName);
            $thumb->resize($width, $height);
            $thumb->save($folder . '/' . $width . $height . '_' . $fileName);
        }
    }

    public function actionBlockUser() {
        $id = $_POST['id'];
        $type = $_POST['type'];

        if ($type == 'disabled') {
            $is_active = "N";
        } else {
            $is_active = "Y";
        }
        if ($id > 0) {
            User::model()->updateByPK($id, array('isActive' => $is_active, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionPrintUsersPdf() {

        $model = new Order();
        $display_type = Yii::app()->request->getParam('display_type');
        $warehouse_id = Yii::app()->request->getParam('warehouse_id');
        $level = Yii::app()->request->getParam('level');
        $condition = '1=1';
        $condition .= ' AND t.isActive="Y" AND t.level!=0 ';
        if ($display_type == 2) {

            $condition = 't.isActive="Y" AND t.level!=0 AND company_id=' . Yii::app()->user->master_user_company_id;
        }
        if ($warehouse_id != '') {
            $condition .= ' AND t.available_warehouses="' . $warehouse_id . '"';
        }
        if ($level != '') {
            $condition .= ' AND t.level="' . $level . '"';
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name = "branchuser_list";

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.' . $page_name, array('condition' => $condition, 'title' => $title, 'mpdf' => $mPDF1), true));
        $mPDF1->Output("SALES_ORDER_" . $id . ".pdf", 'I');
    }

// ----------added by indhu 14_05_2023---------------------------------------------------------


    public function actionCreateAccessibleBranch() {
        $model = new User();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('users_mis_accessible_branches_form', array('model' => $model), false, false);
    }

    public function actionSaveMisAccessibleBranches() {
        $model = new User();
        if (isset($_POST['User'])) {
            if ((int) @$_POST['User']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['User']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['User'];
            $model->mis_accessible_branches = implode(',', $_POST['User']['mis_accessible_branches']);
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'USER', Yii::app()->user->id, $audit_type, " with username: - {$model->username}  ", "", ""
                );
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['accessibleuser-form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
