<?php
class UploadstockController extends Controller
{
        public function accessRules() {

            return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','UploadInventory','UploadInventoryFile','downloadinventoryuploadformat','SaveInventoryUpload'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

        }

	public function actionIndex()
	{
		$this->render('index');

	}
    
    public function actionUploadinventory() {
            $this->render('upload_inventory_form');
    }
    
    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            if ($contents[1] == "")
                $contents = explode(';', $contents[0]);
            $line_of_text[] = $contents;
            //print_r($line_of_text);
            //die();
        }
        fclose($file_handle);
        return $line_of_text;
    }
  
  public function actionDownloadinventoryuploadformat() {
    	$data = array();    
    	$data[0][0]     = 'Sales Product';
    	$data[0][1]     = 'Description';
    	$data[0][2]     = 'Brand';
        $data[0][3]     = "Rate";
    	$data[0][4]     = "Unit";
    	$data[0][5]     = "Tax Code"; 
    	$data[0][6]     = "Tax (%)";   	
    	$data[0][7]     = "Weight";
    	$data[0][8]     = "Volume";
    	$data[0][9]     = "Re-order level";
    	$data[0][10]    = "Re-order lot";
    	$data[0][11]    = "HS-Code";
        $data[0][12]    = "B-No";
    	$data[0][13]    = "Warehouse";
    	$data[0][14]    = "Rack";
    	$data[0][15]    = "Bin";
    	$data[0][16]    = "Barcode";
    	$data[0][17]    = "Generic Name"; 
    	$data[0][18]    = 'Hire Product';
    	$data[0][19]    = "Purchasing Part#/OEM No";
    	$data[0][20]    = "Sales Qty"; 
    	$data[0][21]    = "Sales Serial No";
    	$data[0][22]    = "Hire Qty";
    	$data[0][23]    = "Hire Serial No"; 
    	$data[0][24]    = "Total Qty";
    	$data[0][25]    = "Serial No together";
    	$data[0][26]    = "Serial Yes/No"; 
    	$data[0][27]    = "Machine Type";
    	
    	$this->array_to_csv_download($data,"UPLOAD_INVENTORY.csv");
    
    }
    
    public function actionSaveInventoryUpload() {
    	
        $model= new UploadInventory();
        if(isset($_POST['UploadInventory'])){
            $model->attributes = $_POST['UploadInventory'];
            $model->uploadfile = $_POST['UploadInventory']['uploadfile'];
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            if($model->validate()){
            
                $model->save(false);
                $file_name   = $_POST['UploadInventory']['uploadfile'];

                $from_file = $this->readCSV("upload/inventory/".$file_name);
                $jsonData = array();
                $tax_code_flag = 0;
                $tax_percentage_flag=0;
                foreach (array_slice($from_file, 1) as $i => $eachItem) {

                    $product_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
                    $description            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                    $brand_name             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                    $rate                   = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                    $unit_name              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                    $tax_name               = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));  
                    $tax_percentage         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));                    
                    $weight                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
                    $volume                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
                    $re_order_level         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[9]), '"'));
                    $re_order_lot           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[10]), '"'));
                    $hsir_code              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[11]), '"'));
                    $bno                    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[12]), '"'));                
                    $warehouse_name         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[13]), '"'));
                    $rack                   = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[14]), '"'));
                    $bin                    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[15]), '"'));
                    $barcode                = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[16]), '"'));
                    $generic_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[17]), '"'));
                    $generic_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[18]), '"'));
                    $bin                    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[15]), '"'));
                    $barcode                = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[16]), '"'));
                    $generic_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[17]), '"'));
                    $hiring_part_number     = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[18]), '"'));
                    $oem_number             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[19]), '"'));
                    $sales_qty              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[20]), '"'));
                    $product_serial_no      = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[21]), '"'));
                    $hiring_qty             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[22]), '"'));
                    $hiring_serial_no       = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[23]), '"'));
                    $total_sales_hire_qty   = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[24]), '"'));
                    $sales_hire_serail_no   = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[25]), '"'));
                    $serail_no_status       = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[26]), '"'));
                    $machine_type           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[27]), '"'));
                    if($machine_type=="M"){
                        $serail_no_status="Y";
                    }
                    
                    

                    /**********   find Generic ******************************/
                    
                    if (strlen($tax_name) > 0 && $tax_name!="Tax Code" && strlen($tax_percentage) > 0 && strlen($product_name) > 0 && $product_name!="Product" && strlen($brand_name) > 0 &&  $brand_name!="Brand" && strlen($unit_name)>0 && $unit_name!="Unit") {
                    $model_generic  = new MasGeneric();
                    if (strlen($generic_name) > 0 && $generic_name!="Generic Name") {
                
                        $generic_count = $model_generic->count(array('condition' => 'generic_name="'.$generic_name.'"'));
                        if($generic_count>0){
                            $model_generic = $model_generic->find('generic_name="'.$generic_name.'"');
                            $generic_id    = $model_generic->id;
                        }
                        else{
                            $model_generic->generic_name  = $generic_name;
                            $model_generic->generic_description  = "";   
                            $model_generic->is_Active  = "Y";                    
                            $model_generic->created_by  = Yii::app()->user->id;;
                            $model_generic->updated_by  = "";
                            $model_generic->created_date_time  = date('Y-m-d h:i:s');
                            $model_generic->save(false);
                            $generic_id    = $model_generic->id;
                        }                
                    }
                    else if(strlen($generic_name)==0 || $generic_name=="Generic Name"){
                       $generic_count = $model_generic->count(array('condition' => 'generic_name="None"'));
                        if($generic_count>0){
                            $model_generic = $model_generic->find('generic_name="None"');
                            $generic_id    = $model_generic->id;
                        }
                        else{
                            $model_generic->generic_name  = "None";
                            $model_generic->generic_description  = "None";   
                            $model_generic->is_Active  = "Y";                    
                            $model_generic->created_by  = Yii::app()->user->id;;
                            $model_generic->updated_by  = "";
                            $model_generic->created_date_time  = date('Y-m-d h:i:s');
                            $model_generic->save(false);
                            $generic_id    = $model_generic->id;
                        }                 
                    }
                    /**********   find Tax ******************************/
              
                    $model_tax  = new MasInvTax();
                    if (strlen($tax_name) > 0 && $tax_name!="Tax Code" && strlen($tax_percentage) > 0) {
                
                        $tax_count = $model_tax->count(array('condition' => 'tax_code="'.$tax_name.'"'));
                        if($tax_count>0){
                            $model_tax = $model_tax->find('tax_code="'.$tax_name.'"');
                            $tax_id    = $model_tax->id;
                        }
                        else{
                            $model_tax->tax_code  = $tax_name;
                            if(strlen($tax_percentage) > 0){
                                $model_tax->percentage  = $tax_percentage;  
                            }
                            else{
                                $model_tax->percentage  = "5";//default  
                            }
                            $model_tax->isActive  = "Y";                    
                            $model_tax->created_by  = Yii::app()->user->id;
                            $model_tax->updated_by  = "";
                            $model_tax->created_datetime  = date('Y-m-d h:i:s');
                            $model_tax->save(false);
                            $tax_id    = $model_tax->id;
                        }

                    }
                    
                    /**********   find Unit ******************************/
              
                    $model_unit  = new Unit();
                    if (strlen($unit_name) > 0  && $unit_name!="Unit") {                    
                        $unit_count = $model_unit->count(array('condition' => 'unit_name="'.$unit_name.'"'));
                        if($unit_count>0){
                            $model_unit = $model_unit->find('unit_name="'.$unit_name.'"');
                            $unit_id    = $model_unit->id;
                        }
                        else{
                            $model_unit->unit_name  = $unit_name;
                            $model_unit->symbol  = $unit_name;   
                            $model_unit->unit_type  = "1";  
                            $model_unit->isActive  = "Y";                    
                            $model_unit->created_by  = Yii::app()->user->id;;
                            $model_unit->updated_by  = "";
                            $model_unit->created_datetime  = date('Y-m-d h:i:s');
                            $model_unit->save(false);
                            $unit_id    = $model_unit->id;
                        }
                    }
            
                    /**********   find brand / class ******************************/
                    
                    $model_brand  = new ProductClass();
                    if (strlen($brand_name) > 0  && $brand_name!="Brand") {                    
                        $brand_count = $model_brand->count(array('condition' => 'product_class="'.$brand_name.'"'));
                        if($brand_count>0){
                            $model_brand = $model_brand->find('product_class="'.$brand_name.'"');
                            $brand_id    = $model_brand->id;
                        }
                        else{
                            $model_brand->product_class  = $brand_name;
                            $model_brand->description  = "";                    
                            $model_brand->save(false);
                            $brand_id    = $model_brand->id;
                        }                    
                    }
                    if(strlen($rack)>0 && $rack!="Rack"){
                        $model_rack  = new MasInvRack();
                        $rack_count = $model_rack->count(array('condition' => 'name="'.$rack.'"'));
                        if($rack_count>0){
                            $model_rack = $model_rack->find('name="'.$rack.'"');
                            $rack_id    = $model_rack->id;
                        }
                        else{
                            $model_rack->name  = $rack;
                            $model_rack->save(false);
                            $rack_id    = $model_rack->id;
                        }                    
                    }
                    //save to bin
                     if(strlen($bin)>0 && $bin!="Bin"){
                        $model_bin  = new MasInvBin();
                        $bin_count = $model_bin->count(array('condition' => 'name="'.$bin.'"'));
                        if($bin_count>0){
                            $model_bin = $model_bin->find('name="'.$bin.'"');
                            $bin_id    = $model_bin->id;
                        }
                        else{
                            $model_bin->name     = $bin;
                            $model_bin->rack_id  = $rack_id;
                            $model_bin->save(false);
                            $bin_id    = $model_bin->id;
                        }                    
                    }
                    /**********   find Product ******************************/
                    
                    if (strlen($product_name) > 0 && strlen($description) > 0) {
                        
                        $before_qty    = 0;
                        $model_store   = new Store();
                        $product_count = $model_store->count(array('condition' => 'part_number="'.$product_name.'"'));
                        if($product_count>0){                        
                            $model_store = $model_store->find('part_number="'.$product_name.'"');                        
                            $model_store = $model_store->findByPk($model_store->id);
                            //$before_qty  = $model_store->total_quantity;
                        }              
                        $model_store->part_number           = $product_name;
                        $model_store->hiring_part_number    = $hiring_part_number;
                        $model_store->oem_number            = $oem_number;
                        
                        $model_store->generic_id            = $generic_id;
                        $model_store->description           = $description;
                        $model_store->brand_class_id        = $brand_id;
                        $model_store->unit_id               = $unit_id;
                        $model_store->tax_code              = $tax_id;
                        $model_store->weight                = $weight;
                        $model_store->volume                = $volume;
                        //$model_store->total_quantity      = $before_qty+$qty;
                        $model_store->re_order_level        = $re_order_level;
                        $model_store->re_order_lot          = $re_order_lot;              
                        $model_store->hsir_code             = $hsir_code;             
                        $model_store->bar_code              = $barcode;
                        $model_store->notes                 = $notes;
                        $model_store->inventory_item_type   = "1";
                        $model_store->rate                  = $rate;
                        $model_store->rack_id               = $rack_id;
                        $model_store->bin_id                = $bin_id;
                        $model_store->machine_type          = $machine_type;
                        $model_store->have_serial_no        = $serail_no_status;
                        $model_store->service_product_type  = "NI";
                        $model_store->created_date_time     = date('Y-m-d h:i:s');
                        $model_store->created_by            = Yii::app()->user->id;
                                     
                        $model_store->save(false);
                        $product_id  = $model_store->id;
                        
                        /**********   find Warehouse ******************************/
                                                         
                        if (strlen($warehouse_name) > 0 && $warehouse_name!="Warehouse") {                            
                            $model_warehouse1         = MasInventoryWarehouse::model()->find("isBaseWareHouse='Y'");
                            $default_ware_house_id     = $model_warehouse1->id;                            
                            $warehouse_count = MasInventoryWarehouse::model()->count('warehouse_name="'.$warehouse_name.'"');                        
                            if($warehouse_count>0){
                                $model_warehouse = MasInventoryWarehouse::model()->find('warehouse_name="'.$warehouse_name.'"');
                                $warehouse_id    = $model_warehouse->id;
                            }
                            else{
                                $warehouse_id    = $default_ware_house_id;
                            }                
                        } 
                        else{
                            $model_warehouse1         = MasInventoryWarehouse::model()->find("isBaseWareHouse='Y'");
                            $default_ware_house_id     = $model_warehouse1->id; 
                        }
                        if($product_id > 0){
            
                            /**********   Opening Balance ******************************/
                            
                            /*$opening_bal_count = OpeningBalance::model()->count('product_id="'.$product_id.'"');
                            if($opening_bal_count>0){
                            }
                            else{
                                $opening_balance_model = new OpeningBalance;
                                $opening_balance_model->product_id=$product_id;
                                $opening_balance_model->opening_quantity=$qty;
                                $opening_balance_model->save(false);
                            }*/
                            
                            /**********   Unit Factor ******************************/
                
                            $model_mom_unit  = new UnitOfMeasurement();
                            if(strlen($unit_name) > 0) {                
                                $factor_count = $model_mom_unit->count(array('condition' => 'name="'.$unit_name.'" AND product_id="'.$product_id.'"'));
                                if($factor_count == 0){
                                    
                                    $factor_count1 = $model_mom_unit->count(array('condition' => 'product_id="'.$product_id.'" AND isBase="Y"'));
                                    $baseunit  = "Y";
                                    if($factor_count1>0){
                                        $baseunit  = "N";
                                    }                                    
                                    $model_mom_unit->product_id        = $product_id;
                                    $model_mom_unit->base_unit         = $unit_id;
                                    $model_mom_unit->name              = $unit_name;
                                    $model_mom_unit->factor            = "1.000000";
                                    $model_mom_unit->price             = "0.00";                                    
                                    $model_mom_unit->isBase            = $baseunit;
                                    $model_mom_unit->created_by        = Yii::app()->user->id;
                                    $model_mom_unit->created_date_time = date('Y-m-d H:i:s');
                                    $model_mom_unit->save(false);
                                }
                            }
                            
                             $product       = Store::model()->findbyPk($product_id);
                               if($warehouse_id<1){                
                                    $warehouse_id  = $default_ware_house_id;
                               }       
                         
                            /**********   Update Product Location ******************************/
                            
                            if($serail_no_status=='Y'){//serial no exist
                                $location_count = $total_sales_hire_qty;
                                $location_qty = 1;
                                $location_hire_qty = 1;
                            }
                            else{
                                $location_count = 1;
                                $location_qty = $total_sales_hire_qty;
                                $location_hire_qty = $hiring_qty;
                            }
                            
                                     $arr_sales_hire_serail_no = array();
                                    if(!empty($sales_hire_serail_no)){
                                        $arr_sales_hire_serail_no = explode("/",$sales_hire_serail_no);
                                    }
                            
                            for($i=0;$i<$location_count;$i++){
                                if ($product_id>0 && $total_sales_hire_qty>0 ) {
                                    
                                    $location_serial_no="";
                                    if(count($arr_sales_hire_serail_no) > 0){
                                            $location_serial_no = trim($arr_sales_hire_serail_no[$i]);
                                    }
                                    $modelProLocDetails                     = new ProductLocationDetails;
                                    //To get product location exist
                                    $arr_product_location_details = ProductLocationDetails::model()->find(array('condition'=>'product_id='.$product_id.' AND warehouse_id='.$warehouse_id.' AND rack_id='.$rack_id.' AND bin_id='.$bin_id.''));
                                    if(count($arr_product_location_details) > 0){
                    				    if($serail_no_status=='Y'){
                    				       // $modelProLocDetails->id=0;
                    				        $modelProLocDetails->quantity           = $location_qty;
                    				    }
                    				    else{
                    				        $modelProLocDetails = $modelProLocDetails->findByPk($arr_product_location_details->id);
                    				        $modelProLocDetails->id                 =   $arr_product_location_details->id;
                    				        $modelProLocDetails->quantity           = $arr_product_location_details->quantity + $location_qty;
                    				    }
                                    }
                                    else{
                                        //$modelProLocDetails->id=0;
                    				    $modelProLocDetails->quantity           = $location_qty;
                                    }
                                    
                    				
                    				$modelProLocDetails->header_id          = 0;
                    				$modelProLocDetails->header_item_id     = 0;
                    				$modelProLocDetails->product_id         = $product_id;
                    				$modelProLocDetails->bill_of_entry      = "UPLOAD_STOCK";
                    				$modelProLocDetails->warehouse_id       = $warehouse_id;
                    				$modelProLocDetails->rack_id            = $rack_id;
                    				$modelProLocDetails->bin_id             = $bin_id;
                    				$modelProLocDetails->batch_no           = "";
                    				$modelProLocDetails->serial_no          = $location_serial_no;
                    				$modelProLocDetails->transaction_type   = "UPLOAD_STOCK";
                    				$modelProLocDetails->created_by         = Yii::app()->user->id;
                    				$modelProLocDetails->created_date       = date('Y-m-d h:i:s');
                    				$modelProLocDetails->manufacturing_date = "0000-00-00";
                    				$modelProLocDetails->expiry_date        = "0000-00-00";
                                    $modelProLocDetails->isActive = 'Y';
                    				$modelProLocDetails->save(false);
                    				$modelProLocDetails->refresh();
                    				$modeStockLedger = new StockLedger();
                                    $modeStockLedger->product_id = $product_id;
                                    $modeStockLedger->part_number = $product_name;
                                    $modeStockLedger->description = $description;
                                    $modeStockLedger->product_location_id = $modelProLocDetails->id;
                                    $modeStockLedger->transaction_type = 'UPLOAD_STOCK';
                                    $modeStockLedger->warehouse_id = $warehouse_id;   
                                    $modeStockLedger->rack_id = $rack_id;
                                    $modeStockLedger->bin_id = $bin_id;
                                    $modeStockLedger->cost_price = $rate;
                                    $modeStockLedger->quantity = $location_qty;
                                    $modeStockLedger->transaction_date = date("Y-m-d");
                                    $modeStockLedger->header_id = 0;
                                    $modeStockLedger->created_by = Yii::app()->user->id;
                                    $modeStockLedger->created_date = date("Y-m-d H:i:s");
                                    $modeStockLedger->save(false);
                                    
                    			}
                            }
                            
                              if($serail_no_status=='Y'){//serial no exist
                                $hiring_location_count = $hiring_qty;
                                $hiring_location_qty = 1;
                                $hiring_location_hire_qty = 1;
                            }
                            else{
                                $hiring_location_count = 1;
                                $hiring_location_qty = $total_sales_hire_qty;
                                $hiring_location_hire_qty = $hiring_qty;
                            }
                            
                            
                            
                            if($hiring_qty > 0){
                                
                                $arr_hiring_warehouse = MasInventoryWarehouse::model()->find('warehouse_code="HIR"');
                                    
                                  $arr_hiring_serail_no = array();
                                    if(!empty($hiring_serial_no)){
                                        $arr_hiring_serail_no = explode("/",$hiring_serial_no);
                                    }
                                    
                                for($j=0;$j<$hiring_location_count;$j++){
                                    
                                   $location_hiring_serial_no="";
                                    if(count($arr_hiring_serail_no) > 0){
                                            $location_hiring_serial_no = trim($arr_hiring_serail_no[$j]);
                                    }
                                    if(!empty($location_hiring_serial_no)){
                                    //To get product location details
                                        $arr_current_product_location = ProductLocationDetails::model()->find(array('condition'=>'serial_no="'.$location_hiring_serial_no.'"'));
                                    }
                                    else{
                                        $arr_current_product_location = ProductLocationDetails::model()->find(array('condition'=>'product_id='.$product_id.' AND warehouse_id='.$warehouse_id.' AND rack_id='.$rack_id.' AND bin_id='.$bin_id.''));
                                    }
                                    
                                    
                                    $modelProLocHiringDetails                     = new ProductLocationHiringDetails;
                                    //To get product location exist
                                    $arr_product_location_hiring_details = ProductLocationHiringDetails::model()->find(array('condition'=>'product_id='.$product_id.' AND warehouse_id='.$warehouse_id.' AND rack_id='.$rack_id.' AND bin_id='.$bin_id.''));
                                    if(count($arr_product_location_hiring_details) > 0){
                    				    if($serail_no_status=='Y'){
                    				        $modelProLocHiringDetails->id=0;
                    				        $modelProLocHiringDetails->quantity           = $hiring_location_qty;
                    				    }
                    				    else{
                    				        $modelProLocHiringDetails = $modelProLocDetails->findByPk($arr_product_location_hiring_details->id);
                    				        $modelProLocHiringDetails->id                 =   $arr_product_location_hiring_details->id;
                    				        $modelProLocHiringDetails->quantity           = $arr_product_location_hiring_details->quantity + $hiring_location_qty;
                    				    }
                                    }
                                    else{
                                        $modelProLocHiringDetails->id=0;
                    				    $modelProLocHiringDetails->quantity           = $hiring_location_qty;
                                    }
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    /************** START Data save into stock ledger *****************/
                                    $modeStockLedger = new StockLedger();
                                    $modeStockLedger->product_id = $product_id;
                                    $modeStockLedger->part_number = $product_name;
                                    $modeStockLedger->description = $description;
                                    $modeStockLedger->product_location_id = $arr_current_product_location->id;
                                    $modeStockLedger->transaction_type = 'UPLOAD_HIRING_TRANSFER';
                                    $modeStockLedger->warehouse_id = $warehouse_id;   
                                    $modeStockLedger->rack_id = $rack_id;
                                    $modeStockLedger->bin_id = $bin_id;
                                    $modeStockLedger->cost_price = $rate;
                                    $modeStockLedger->quantity = -1 * $location_hire_qty;
                                    $modeStockLedger->transaction_date = date("Y-m-d");
                                    $modeStockLedger->header_id = 0;
                                    $modeStockLedger->created_by = Yii::app()->user->id;
                                    $modeStockLedger->created_date = date("Y-m-d H:i:s");
                                    
                                    $modeStockLedger->save(false);
                                    /************** END Data save into stock ledger *****************/
                                    
                                    /************** START Data save into hiring product location *****************/
                                    //$modelProLocHiringDetails = new ProductLocationHiringDetails;
                    				$modelProLocHiringDetails->product_location_id = $arr_current_product_location->id;
                    				$modelProLocHiringDetails->header_id = 0;
                    				$modelProLocHiringDetails->header_item_id  = 0;
                    				$modelProLocHiringDetails->product_id = $product_id;
                    				$modelProLocHiringDetails->part_number = $hiring_part_number;
                    				$modelProLocHiringDetails->description = $description;
                    				$modelProLocHiringDetails->bill_of_entry ="UPLOAD_STOCK";
                    				$modelProLocHiringDetails->warehouse_id=$arr_hiring_warehouse->id;
                    				$modelProLocHiringDetails->rack_id=0;
                    				$modelProLocHiringDetails->bin_id=0;
                    				$modelProLocHiringDetails->batch_no="";
                    				$modelProLocHiringDetails->serial_no=$location_hiring_serial_no;
                    				$modelProLocHiringDetails->quantity=$location_hire_qty;
                    				$modelProLocHiringDetails->transaction_type='UPLOAD_HIRING_TRANSFER_IN';
                    				$modelProLocHiringDetails->created_by = Yii::app()->user->id;
                    				$modelProLocHiringDetails->created_date = date('Y-m-d h:i:s');
                    				$modelProLocHiringDetails->manufacturing_date = "0000-00-00";
                    				$modelProLocHiringDetails->expiry_date = "0000-00-00";
                                    $modelProLocHiringDetails->isActive = 'Y';
                                    $modelProLocHiringDetails->save(false);
                                    
                                    //update product location if it is moved to hiring qty
                                    ProductLocationDetails::model()->updateByPk($arr_current_product_location->id, array('quantity' => ($arr_current_product_location->quantity-$location_hire_qty)));
                                    
                                    
                                    
                                    /************** END Data save into hiring product location *****************/
                                    
                                    /************** START Data save into hiring stock ledger *****************/
                                    $modelHiringStockLedger = new StockLedgerHiring();
                                    $modelHiringStockLedger->product_id = $product_id;
                                    $modelHiringStockLedger->product_location_id = $arr_current_product_location->id;
                                    $modelHiringStockLedger->transaction_type = "UPLOAD_HIRING_TRANSFER_IN";
                                    $modelHiringStockLedger->warehouse_id = $arr_hiring_warehouse->id;
                                    $modelHiringStockLedger->rack_id = 0;
                                    $modelHiringStockLedger->bin_id = 0;
                                    $modelHiringStockLedger->cost_price = $rate;
                                    $modelHiringStockLedger->quantity = abs($location_hire_qty);
                                    $modelHiringStockLedger->transaction_date = date("Y-m-d");
                                    $modelHiringStockLedger->header_id = 0;
                                    $modelHiringStockLedger->created_by = Yii::app()->user->id;
                                    $modelHiringStockLedger->created_date = date("Y-m-d H:i:s");
                                    //echo '<pre>';
                    				//print_r($modelHiringStockLedger);
                                    $modelHiringStockLedger->save(false);
                                    /************** END Data save into hiring stock ledger *****************/
                                }
                            }
                            
               }
            }
            
            $arr_inventory_updated_part_number[] = $product_name;
            
           }
           else{
               $arr_part_number[]=$product_name;
           }
        }
            /* $jsonData['model'] = $model;
             $jsonData['status'] = "success";
              echo CJSON::encode($jsonData);*/
              
              $jsonData['errors']=array();
            	if(count($arr_part_number) > 0 && $arr_part_number!="")
            	{
            		$jsonData['errors']=ltrim("Please add tax code,unit,tax percentage,brand for the following part number <br>".implode(",", $arr_part_number),",");
            	}
            	
            	$jsonData['msg']=array();
            	if(count($arr_inventory_updated_part_number) > 0 && $arr_inventory_updated_part_number!="")
            	{
            		$jsonData['msg']=ltrim("The following part number(s) <br>".implode(",", $arr_inventory_updated_part_number)." are added!",",");
            	}
            	$jsonData['model'] = $model;
            	$jsonData['status'] = "success";
            
            	echo CJSON::encode($jsonData);
              
              
              
        }
        
        else{
            $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
        
        }     
             
        }
        else{
            $jsonData['status'] = "fail";
             echo CJSON::encode($jsonData);
        }      
            
    }
    
    /**************************   END INVENTORY UPLOAD *********************************/
    
    public function actionSaveInventoryUploadOld() {
    	
        $model= new UploadInventory();
        if(isset($_POST['UploadInventory'])){
            $model->attributes = $_POST['UploadInventory'];
            $model->uploadfile = $_POST['UploadInventory']['uploadfile'];
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            if($model->validate()){
            
                $model->save(false);
                $file_name   = $_POST['UploadInventory']['uploadfile'];

                $from_file = $this->readCSV("upload/inventory/".$file_name);
                $jsonData = array();
                $tax_code_flag = 0;
                $tax_percentage_flag=0;
                foreach (array_slice($from_file, 1) as $i => $eachItem) {

                    $product_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
                    $description            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                    $brand_name             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                    $rate                   = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                    $unit_name              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                    $tax_name               = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));  
                    $tax_percentage         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));                    
                    $weight                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
                    $volume                 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
                    $re_order_level         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[9]), '"'));
                    $re_order_lot           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[10]), '"'));
                    $hsir_code              = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[11]), '"'));
                    $bno                    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[12]), '"'));                
                    $warehouse_name         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[13]), '"'));
                    $rack                   = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[14]), '"'));
                    $bin                    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[15]), '"'));
                    $barcode                = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[16]), '"'));
                    $qty                    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[17]), '"'));
                    $generic_name           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[18]), '"'));
                    

                    /**********   find Generic ******************************/
                    
                    if (strlen($tax_name) > 0 && $tax_name!="Tax Code" && strlen($tax_percentage) > 0 && strlen($product_name) > 0 && $product_name!="Product" && strlen($brand_name) > 0 &&  $brand_name!="Brand" && strlen($unit_name)>0 && $unit_name!="Unit") {
                    $model_generic  = new MasGeneric();
                    if (strlen($generic_name) > 0 && $generic_name!="Generic Name") {
                
                        $generic_count = $model_generic->count(array('condition' => 'generic_name="'.$generic_name.'"'));
                        if($generic_count>0){
                            $model_generic = $model_generic->find('generic_name="'.$generic_name.'"');
                            $generic_id    = $model_generic->id;
                        }
                        else{
                            $model_generic->generic_name  = $generic_name;
                            $model_generic->generic_description  = "";   
                            $model_generic->is_Active  = "Y";                    
                            $model_generic->created_by  = Yii::app()->user->id;;
                            $model_generic->updated_by  = "";
                            $model_generic->created_date_time  = date('Y-m-d h:i:s');
                            $model_generic->save(false);
                            $generic_id    = $model_generic->id;
                        }                
                    }
                    else if(strlen($generic_name)==0 || $generic_name=="Generic Name"){
                       $generic_count = $model_generic->count(array('condition' => 'generic_name="None"'));
                        if($generic_count>0){
                            $model_generic = $model_generic->find('generic_name="None"');
                            $generic_id    = $model_generic->id;
                        }
                        else{
                            $model_generic->generic_name  = "None";
                            $model_generic->generic_description  = "None";   
                            $model_generic->is_Active  = "Y";                    
                            $model_generic->created_by  = Yii::app()->user->id;;
                            $model_generic->updated_by  = "";
                            $model_generic->created_date_time  = date('Y-m-d h:i:s');
                            $model_generic->save(false);
                            $generic_id    = $model_generic->id;
                        }                 
                    }
                    /**********   find Tax ******************************/
              
                    $model_tax  = new MasInvTax();
                    if (strlen($tax_name) > 0 && $tax_name!="Tax Code" && strlen($tax_percentage) > 0) {
                
                        $tax_count = $model_tax->count(array('condition' => 'tax_code="'.$tax_name.'"'));
                        if($tax_count>0){
                            $model_tax = $model_tax->find('tax_code="'.$tax_name.'"');
                            $tax_id    = $model_tax->id;
                        }
                        else{
                            $model_tax->tax_code  = $tax_name;
                            if(strlen($tax_percentage) > 0){
                                $model_tax->percentage  = $tax_percentage;  
                            }
                            else{
                                $model_tax->percentage  = "5";//default  
                            }
                            $model_tax->isActive  = "Y";                    
                            $model_tax->created_by  = Yii::app()->user->id;
                            $model_tax->updated_by  = "";
                            $model_tax->created_datetime  = date('Y-m-d h:i:s');
                            $model_tax->save(false);
                            $tax_id    = $model_tax->id;
                        }

                    }
                    
                    /**********   find Unit ******************************/
              
                    $model_unit  = new Unit();
                    if (strlen($unit_name) > 0  && $unit_name!="Unit") {                    
                        $unit_count = $model_unit->count(array('condition' => 'unit_name="'.$unit_name.'"'));
                        if($unit_count>0){
                            $model_unit = $model_unit->find('unit_name="'.$unit_name.'"');
                            $unit_id    = $model_unit->id;
                        }
                        else{
                            $model_unit->unit_name  = $unit_name;
                            $model_unit->symbol  = $unit_name;   
                            $model_unit->unit_type  = "1";  
                            $model_unit->isActive  = "Y";                    
                            $model_unit->created_by  = Yii::app()->user->id;;
                            $model_unit->updated_by  = "";
                            $model_unit->created_datetime  = date('Y-m-d h:i:s');
                            $model_unit->save(false);
                            $unit_id    = $model_unit->id;
                        }
                    }
                    /**********   find brand / class ******************************/
                    
                    $model_brand  = new ProductClass();
                    if (strlen($brand_name) > 0  && $brand_name!="Brand") {                    
                        $brand_count = $model_brand->count(array('condition' => 'product_class="'.$brand_name.'"'));
                        if($brand_count>0){
                            $model_brand = $model_brand->find('product_class="'.$brand_name.'"');
                            $brand_id    = $model_brand->id;
                        }
                        else{
                            $model_brand->product_class  = $brand_name;
                            $model_brand->description  = "";                    
                            //$model_brand->created_by  = Yii::app()->user->id;
                            //$model_brand->updated_by  = "";
                            //$model_brand->created_date_time  = date('Y-m-d h:i:s');
                            $model_brand->save(false);
                            $brand_id    = $model_brand->id;
                        }                    
                    }
                    if(strlen($rack)>0 && $rack!="Rack"){
                        $model_rack  = new MasInvRack();
                        $rack_count = $model_rack->count(array('condition' => 'name="'.$rack.'"'));
                        if($rack_count>0){
                            $model_rack = $model_rack->find('name="'.$rack.'"');
                            $rack_id    = $model_rack->id;
                        }
                        else{
                            $model_rack->name  = $rack;
                            $model_rack->save(false);
                            $rack_id    = $model_rack->id;
                        }                    
                    }
                    /**********   find Product ******************************/
                    
                    if (strlen($product_name) > 0 && strlen($description) > 0) {
                        
                        $before_qty    = 0;
                        $model_store   = new Store();
                        $product_count = $model_store->count(array('condition' => 'part_number="'.$product_name.'"'));
                        if($product_count>0){                        
                            $model_store = $model_store->find('part_number="'.$product_name.'"');                        
                            $model_store = $model_store->findByPk($model_store->id);
                            //$before_qty  = $model_store->total_quantity;
                        }              
                        $model_store->part_number       = $product_name;
                        $model_store->generic_id        = $generic_id;
                        $model_store->description       = $description;
                        $model_store->brand_class_id    = $brand_id;
                        $model_store->unit_id           = $unit_id;
                        $model_store->tax_code        = $tax_id;
                        $model_store->weight          = $weight;
                        $model_store->volume          = $volume;
                        //$model_store->total_quantity  = $before_qty+$qty;
                        $model_store->re_order_level  = $re_order_level;
                        $model_store->re_order_lot    = $re_order_lot;              
                        $model_store->hsir_code       = $hsir_code;             
                        $model_store->bar_code        = $barcode;
                        $model_store->notes           = $notes;
                        $model_store->inventory_item_type  = "1";
                        $model_store->rate              = $rate;
                        $model_store->rack_id              = $rack_id;
                        $model_store->bin_id              = 1;
                        $model_store->created_date_time    = date('Y-m-d h:i:s');
                        $model_store->created_by           = Yii::app()->user->id;
                                     
                        $model_store->save(false);
                        $product_id  = $model_store->id;
                        
                        /**********   find Warehouse ******************************/
                                                         
                        if (strlen($warehouse_name) > 0 && $warehouse_name!="Warehouse") {                            
                            $model_warehouse1         = MasInventoryWarehouse::model()->find("isBaseWareHouse='Y'");
                            $default_ware_house_id     = $model_warehouse1->id;                            
                            $warehouse_count = MasInventoryWarehouse::model()->count('warehouse_name="'.$warehouse_name.'"');                        
                            if($warehouse_count>0){
                                $model_warehouse = MasInventoryWarehouse::model()->find('warehouse_name="'.$warehouse_name.'"');
                                $warehouse_id    = $model_warehouse->id;
                            }
                            else{
                                $warehouse_id    = $default_ware_house_id;
                            }                
                        } 
                        else{
                            $model_warehouse1         = MasInventoryWarehouse::model()->find("isBaseWareHouse='Y'");
                            $default_ware_house_id     = $model_warehouse1->id; 
                        }
                        if($product_id > 0){
            
                            /**********   Opening Balance ******************************/
                            
                            $opening_bal_count = OpeningBalance::model()->count('product_id="'.$product_id.'"');
                            if($opening_bal_count>0){
                            }
                            else{
                                $opening_balance_model = new OpeningBalance;
                                $opening_balance_model->product_id=$product_id;
                                $opening_balance_model->opening_quantity=$qty;
                                $opening_balance_model->save(false);
                            }
                            
                            /**********   Unit Factor ******************************/
                
                            $model_mom_unit  = new UnitOfMeasurement();
                            if(strlen($unit_name) > 0) {                
                                $factor_count = $model_mom_unit->count(array('condition' => 'name="'.$unit_name.'" AND product_id="'.$product_id.'"'));
                                if($factor_count == 0){
                                    
                                    $factor_count1 = $model_mom_unit->count(array('condition' => 'product_id="'.$product_id.'" AND isBase="Y"'));
                                    $baseunit  = "Y";
                                    if($factor_count1>0){
                                        $baseunit  = "N";
                                    }                                    
                                    $model_mom_unit->product_id        = $product_id;
                                    $model_mom_unit->base_unit         = $unit_id;
                                    $model_mom_unit->name              = $unit_name;
                                    $model_mom_unit->factor            = "1.000000";
                                    $model_mom_unit->price             = "0.00";                                    
                                    $model_mom_unit->isBase            = $baseunit;
                                    $model_mom_unit->created_by        = Yii::app()->user->id;
                                    $model_mom_unit->created_date_time = date('Y-m-d H:i:s');
                                    $model_mom_unit->save(false);
                                }
                            }
                    /*        else if(strlen($unit_name)==0 || $unit_name=="Unit"){
                                $factor_count = $model_mom_unit->count(array('condition' => 'name="None" AND product_id="'.$product_id.'"'));
                                if($factor_count == 0){
                                    
                                    $factor_count1 = $model_mom_unit->count(array('condition' => 'product_id="'.$product_id.'" AND isBase="Y"'));
                                    $baseunit  = "Y";
                                    if($factor_count1>0){
                                        $baseunit  = "N";
                                    }                                    
                                    $model_mom_unit->product_id        = $product_id;
                                    $model_mom_unit->base_unit         = $unit_id;
                                    $model_mom_unit->name              = $unit_name;
                                    $model_mom_unit->factor            = "1.000000";
                                    $model_mom_unit->price             = "0.00";                                    
                                    $model_mom_unit->isBase            = $baseunit;
                                    $model_mom_unit->created_by        = Yii::app()->user->id;
                                    $model_mom_unit->created_date_time = date('Y-m-d H:i:s');
                                    $model_mom_unit->save(false);
                                }
                            }*/
                         
                            /**********   Update Product Location ******************************/
                            
                            $product       = Store::model()->findbyPk($product_id);
                            //$old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id='.$product_id.' ')->queryScalar();
                        
                                /*if($product_count == 0 AND $warehouse_id >0 ){
                                    $newloc1 = new ProductLocation;
                                    $newloc1->stock_id = $product_id;
                                    $newloc1->warehouse_id = $default_ware_house_id;
                                    $newloc1->rack = "";
                                    $newloc1->bin = "";
                                    $newloc1->quantity = 0;
                                    $newloc1->save(false);
                               }            */       
                               if($warehouse_id<1){                
                                    $warehouse_id  = $default_ware_house_id;
                               }                    
                               /*$con = 'stock_id='. $product_id;                   
                               if($warehouse_id > 0)
                                   $con .= ' AND warehouse_id='.$warehouse_id;
                               if($rack > 0)
                                   $con .= ' AND rack='.$rack;
                               if($bin > 0)
                                   $con .= ' AND bin='.$bin;
                                   
                               $productlocation = ProductLocation::model()->find(array('condition' => $con));
                               if( $productlocation->id > 0){
                                        $loc = ProductLocation::model()->findByPk($productlocation->id);
                                        $old = $loc->quantity;
                                        $loc->quantity = $old+$qty;
                                        $loc->save(false);
                                }else{
                                    $newloc = new ProductLocation;
                                    $newloc->stock_id = $product_id;
                                    $newloc->warehouse_id = $warehouse_id;
                                    $newloc->rack = $rack;
                                    $newloc->bin = $bin;
                                    $newloc->quantity = $qty;
                                    $newloc->save(false);
                                }                  */    
               }
            }
            
            $arr_inventory_updated_part_number[] = $product_name;
            
           }
           else{
               $arr_part_number[]=$product_name;
           }
        }
            /* $jsonData['model'] = $model;
             $jsonData['status'] = "success";
              echo CJSON::encode($jsonData);*/
              
              $jsonData['errors']=array();
            	if(count($arr_part_number) > 0 && $arr_part_number!="")
            	{
            		$jsonData['errors']=ltrim("Please add tax code,unit,tax percentage,brand for the following part number <br>".implode(",", $arr_part_number),",");
            	}
            	
            	$jsonData['msg']=array();
            	if(count($arr_inventory_updated_part_number) > 0 && $arr_inventory_updated_part_number!="")
            	{
            		$jsonData['msg']=ltrim("The following part number(s) <br>".implode(",", $arr_inventory_updated_part_number)." are added!",",");
            	}
            	$jsonData['model'] = $model;
            	$jsonData['status'] = "success";
            
            	echo CJSON::encode($jsonData);
              
              
              
        }
        
        else{
            $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
        
        }     
             
        }
        else{
            $jsonData['status'] = "fail";
             echo CJSON::encode($jsonData);
        }      
            
    }
    
    /**************************   END INVENTORY UPLOAD *********************************/
    
    
    
        
        
}