<?php

class UnitController extends Controller
{
    //	public function actionIndex()
//	{
//		$this->render('index');
//	}

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'DeleteUnit', 'SaveUnit', 'GetUnitList', 'DirectAdd', 'DirectAddTax', 'Disable', 'SearchUnit', 'UploadUnit', 'DownloadSampleCsv', 'DownloadSampleCsv', 'SaveUnitUploadCsv', 'UploadUnitCsv', 'DownloadErrorCsv'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex()
    {
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['masters_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['mas_inv_unit_view']) &&
                Yii::app()->user->havePermissionOn['masters_menu_view'] &&
                Yii::app()->user->havePermissionOn['mas_inv_unit_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetUnitList()
    {

        $model = new Unit();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'unit_name',
            1 => 'symbol',
            2 => 'unit_type'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (unit_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if ($row->unit_type == 1)
                $type = "Integer";
            else if ($row->unit_type == 2)
                $type = "Decimal";
            else
                $type = " ";

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_unit_edit"])) {
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'unit/create&id=' . $row['id'] . '\',\'Edit Unit\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_unit_delete"])) {
                //    $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUnit('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array(
                $m,
                $row['unit_name'],
                $row['symbol'],
                $type,
                $row['is_base_unit'],
                array('id' => $row['id'], 'code' => $row['unit_name'], 'status' => $row->isActive)
            );


            $m++;

        }




        //                foreach ($model as $row)
//                {
//                    if($row->unit_type==1)
//                        $type="Integer";
//                    else if($row->unit_type==2)
//                        $type="Decimal";
//                    else $type=" ";
//                    
//                    $rowData[]=array($m,$row['unit_name'],$row['symbol'],$type,
//              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'unit/create&id='.$row['id'].'\',\'Edit Unit\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUnit('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model = new Unit();
        $id = (int) Yii::app()->request->getParam('id');
        $from = (int) Yii::app()->request->getParam('from');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('unit_form', array('model' => $model, 'from' => $from), false, true);
    }
    public function actionSaveUnit()
    {
        $model = new Unit();
        if (isset($_POST['Unit'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');

            if ((int) @$_POST['Unit']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['Unit']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
                $edit_flag = 1;
            } else {
                $audit_type = 'CREATED';
            }
            if ($_POST['Unit']['is_base_unit'] == "Y") {
                Unit::model()->updateAll(array('is_base_unit' => 'N'), 'is_base_unit = "Y"');
            }
            $model->is_base_unit = $_POST['Unit']['is_base_unit'];
            $model->attributes = $_POST['Unit'];
            // $model->unit_type=$_POST['Unit']['unit_type'];
            $model->unit_type = isset($_POST['Unit']['unit_type']) && $_POST['Unit']['unit_type'] !== '' ? (int) $_POST['Unit']['unit_type'] : 2; // Default to decimal
            if ($model->save()) {
                if ($audit_type == 'UPDATED') {
                    $condition1 = 'base_unit=' . $model->id;
                    UnitOfMeasurement::model()->updateAll(['name' => $model->unit_name], $condition1);
                }
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'UNIT_MASTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with symbol: - {$model->symbol}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['unit_form'];
                $jsonData['from'] = $_POST['from'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
                // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
            // $this->render('bank_form', array('model' => $model), false, true);

        }
    }
    public function actionDeleteUnit()
    {
        $id = $_POST['id'];
        $model_s = Store::model()->findAll(array('condition' => 'unit_id=' . $id . ' '));
        if (empty($model_s)) {
            $model = new Unit();
            $del = $model->findByPk($id); // audit log changes
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'UNIT_MASTER',
                Yii::app()->user->id,
                'DELETED',
                " with symbol: - {$del->symbol}  "
            );
            // end audit log
            echo "success";
        } else {
            echo "fail";
        }

    }

    public function actionDirectAdd()
    {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $symbol = $_POST['symbol'];
        $type = $_POST['type'];
        if ($name != '' && $symbol != '' && $type != '') {
            $modelUnit = new Unit;
            $modelUnit->unit_name = $name;
            $modelUnit->symbol = $symbol;
            $modelUnit->unit_type = $type;
            if ($modelUnit->save()) {

                $data = Unit::getUnits();
                if ($from == 'inventory') {
                    $model = new Store;
                    $field_name = 'unit_id';
                }
                $model->$field_name = $modelUnit->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Unit <span style="color:red;">*<span>'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelUnit, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }


    }

    public function actionDirectAddTax()
    {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $percent = $_POST['percent'];
        if ($name != '' && $percent != '') {
            $modelTax = new MasInvTax;
            $modelTax->tax_code = $name;
            $modelTax->percentage = $percent;
            if ($modelTax->save()) {

                if ($from == 'inventory') {
                    $model = new Store;
                    $field_name = 'tax_code';
                }
                if ($from == 'inventory_1') {
                    $model = new Store;
                    $field_name = 'tax_code_1';
                }
                if ($from == 'inventory_2') {
                    $model = new Store;
                    $field_name = 'tax_code_2';
                }
                if ($from == 'inventory_3') {
                    $model = new Store;
                    $field_name = 'tax_code_3';
                }
                $model->$field_name = $modelTax->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Tax Code <span style="color:red;">*<span>'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelTax, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }


    }

    public function actionDisable()
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new Unit();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y") ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    public function actionSearchUnit()
    {
        $searchTerm = $_GET['term'];
        $id = $_GET['id'];
        $condition = '(symbol LIKE "%' . $searchTerm . '%" OR unit_name LIKE "%' . $searchTerm . '%")';
        $model = new Unit();
        $model = $model->findAll(array('select' => 'id,unit_name,symbol', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['name'] = $eachModel->unit_name;
            $data[$i]['label'] = $eachModel->unit_name;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    // csv bulk upload section
    public function actionUploadUnit()
    {
        //added by nisha on 28-02-2023
        $model = new Unit();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_unit', array('model' => $model), false, true);
    }

    public function actionDownloadSampleCsv()
    {
        $filename = 'unit_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Unit Name*,Sympol';
        Yii::app()->end();
    }

    public function readUnitCSV($csvFile)
    {
        if (!file_exists($csvFile)) {
            throw new Exception("File not found: $csvFile");
        }

        $file_handle = fopen($csvFile, 'r');
        $line_of_text = [];
        while (($contents = fgetcsv($file_handle, 1024, ',')) !== false) {
            $line_of_text[] = $contents;
        }
        fclose($file_handle);

        return $line_of_text;
    }
    public function actionSaveUnitUploadCsv()
    {
        $file_name = Yii::app()->request->getParam('filename');
        $batch = (int) Yii::app()->request->getParam('batch', 1);
        $url = Yii::app()->basePath . '/../uploads/unit_csv/' . $file_name;
        $mas_unit_list = $this->readUnitCSV($url);
        $error_url = Yii::app()->basePath . '/../uploads/unit_csv/error/' . $file_name;
        $error_list = [];
        $error_occurred = false;
        $batch_size = 200;
        $success_count = 0;
        $error_count = 0;
        $non_empty_row_count = 0;
        if (!empty($mas_unit_list)) {
            $header = array_shift($mas_unit_list); // Remove header row only once
        }
        $total_records = count($mas_unit_list);
        $start_index = ($batch - 1) * $batch_size;
        $batch_data = array_slice($mas_unit_list, $start_index, $batch_size);
        // print_r($batch_data);
        // die();
        foreach ($mas_unit_list as $index => $data) {
            if (!empty($data)) {
                $line_number = $index + 2; // Adjust for header row
                $log_remarks = [];

                // Sanitize and validate data

                if ($batch == 1) {
                    $log_remarks = $this->validateAndPrepareLog($data, $log_remarks);
                }


                if (empty($log_remarks)) {
                    $error_list[$line_number] = [
                        'unit_name' => $data[0],
                        'symbol' => $data[1],
                        'log_remarks' => ''
                    ];
                } else {
                    $error_occurred = true;
                    $error_count++;
                    $error_list[$line_number] = [
                        'unit_name' => $data[0],
                        'symbol' => $data[1],
                        'log_remarks' => implode(" | ", $log_remarks)
                    ];
                }
            }
        }
        // var_dump($log_remarks);
        // die();
        if ($error_occurred) {
            // echo 'hii';
            $file_error = fopen($error_url, "w+");
            $error_directory = Yii::app()->basePath . '/../uploads/unit_csv/error/';

            if (!is_dir($error_directory)) {
                mkdir($error_directory, 0777, true);  // Create the directory with appropriate permissions
            }
            if ($file_error === false) {
                // Handle the error if the file cannot be opened
                throw new Exception("Unable to open file for writing: $error_url");
            }
            // Add headers to the CSV file
            $headers = ['Unit Name', 'Log Remarks'];
            fputcsv($file_error, $headers);

            // Add each line from the original CSV, including rows with no errors
            foreach ($error_list as $error_detail) {
                $line = [
                    $error_detail['unit_name'],
                    $error_detail['symbol'],
                    $error_detail['log_remarks'], // Include log remarks, empty if no error
                ];
                fputcsv($file_error, $line);
            }
            fclose($file_error);

            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download Log', array('unit/DownloadErrorCsv', 'id' => $file_name), array(
                'target' => '_blank',
                'style' => '
              display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px;border-radius: -3px;font-size: 12px;
              font-weight: bold; background: #ff4d4f; color: #fff;text-decoration: none;text-align: center; margin-bottom: 10px;'
            )) . '</div>
          <div style="
              font-size: 12px;
              font-weight: bold;
              color: #ff4d4f;
              margin-top: 10px; 
          ">
              Data updation failed. Please see this file.
          </div>';
            echo json_encode($jsonData);

            return; // Return to stop further execution
        }

        foreach ($batch_data as $index => $data) {

            $non_empty_row_count++;
            if (!empty($data)) {
                $line_number = $start_index + $index + 2;
                $log_remarks = [];

                // Sanitize and validate data
                $unit_name = $this->sanitizeData($data[0]);
                $unit_symbol = $this->sanitizeData($data[1]);
                if ($this->isTypeNameExists($unit_name)) {
                    $existing_count++;
                } else {
                    // Save to DB
                    $model = new Unit();
                    $model->created_by = Yii::app()->user->id;
                    $model->updated_by = Yii::app()->user->id;
                    $model->created_datetime = date('Y-m-d H:i:s');
                    $model->updated_datetime = date('Y-m-d H:i:s');
                    $model->unit_name = ucfirst(strtolower($unit_name));
                    $model->symbol = $unit_symbol;
                    $model->is_base_unit = 'N';
                    if ($model->save()) {
                        $success_count++;
                    }
                }


            }
        }
        // $existing_count = ($batch - 1) * $batch_size;

        // Yii::app()->session['batch_no'] = $batch + 1;

        if ($start_index + $batch_size < $total_records) {
            $next_batch = $batch + 1;
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'flag' => 'continue',
                'next_button' => '<a href="javascript:void(0);" 
                          id="next-batch-btn" 
                          data-url="' . Yii::app()->createUrl('unit/SaveUnitUploadCsv', [
                        'filename' => $file_name,
                        'batch' => $next_batch

                    ]) . '"
                          style="display: inline-block; border: 2px solid #000080; padding: 5px 15px; font-size: 12px; font-weight: bold; background: #000080; color: #fff; text-decoration: none;">
                          Upload Next 200
                        </a>',
                'total_records' => $total_records,
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
                'total_records' => $total_records,
            ]);
        }
    }
    public function actionDownloadErrorCsv()
    {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/unit_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    private function sanitizeData($data)
    {
        return !empty($data) ? trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"') : '';
    }

    private function sanitizeNumber($data)
    {
        $sanitizedData = str_replace(',', '', trim($data));
        return is_numeric($sanitizedData) ? (float) $sanitizedData : 0.0;
    }
    private function validateAndPrepareLog($data, &$log_remarks)
    {
        $log_remarks = [];

        // Sanitize and assign data
        $unit_name = $this->sanitizeData($data[0]);



        // Validate 'code'
        if (empty($unit_name)) {

            $log_remarks[] = "Unit Name is required.";
        } else {
            // if ($this->isTypeNameExists($unit_name)) {
            //     $log_remarks[] = "Code must be unique.";
            // }
        }
        // var_dump($log_remarks);

        return $log_remarks;
    }
    private function isTypeNameExists($code)
    {
        $code = strtolower(trim($code));
        return Unit::model()->exists('LOWER(TRIM(unit_name)) = :code', [':code' => $code]);
    }

    public function actionUploadUnitCsv($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // Check if directory exists or create it
        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

        // Define allowed extensions and size limit
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // 2MB

        // Handle file upload
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        // Return JSON response
        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }


}