<?php

class TodolistController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList','Create','Savedetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
     public function actionGetList() {
        $model = new Todolist();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'user_id',
            2 => 'todo_date',
            3 => 'start_time',
            4 => 'end_time',
            5 => 'activity',
            6 => 'isActive',
            7 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (userdetail.first_name LIKE '%".$searchString."%')";      
        }
        $count = $model->with('userdetail')->count(array('condition' => $condition));
        $model = $model->with('userdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' =>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $todo_date='';
            $start_time='';
            if($row['todo_date']!='' && $row['todo_date']!='0000-00-00'){
                $todo_date=date("d/m/Y",strtotime($row->todo_date));
            }
            if($row['start_time']!='' && $row['start_time']!='00:00:00'){
                $start_time=date("H:i",strtotime($row->start_time));
            }
            if($row['end_time']!='' && $row['end_time']!='00:00:00'){
                $end_time=date("H:i",strtotime($row->end_time));
            }
            $active = array('Y' => 'Active', 'C' => 'Completed','N' => 'Inactive',);
            if($row['isActive']=='Y')
            $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'todolist/create&id='.$row['id'].'\',\'Edit Todo List   \',\'xl\')"><i class="fa fa-edit"></i></button>';
            $rowData[] = array($m,$row->userdetail->Fullname ,$todo_date,$start_time, $end_time,$row['activity'],$active[$row['isActive']], $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model       = new Todolist(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }                              
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSavedetails() {
        
         $model = new Todolist;
        if (isset($_POST['Todolist'])) {
            if ((int) @$_POST['Todolist']['id'] > 0) {
                $model->id = (int) $_POST['Todolist']['id'];
                $model = $model->findByPK($model->id);
            }
            $model->attributes = $_POST['Todolist'];
            if ($_POST['Todolist']['todo_date'] != '0000-00-00' && $_POST['Todolist']['todo_date'] != '') {
                $model->todo_date = str_replace('/', '-', $_POST['Todolist']['todo_date']);
                $model->todo_date = date("Y-m-d", strtotime($model->todo_date));
            }
            if ($_POST['Todolist']['start_time'] != '00:00' && $_POST['Todolist']['start_time'] != '') {
                $model->start_time = date("H:i", strtotime($model->start_time));
            }
           if ($_POST['Todolist']['end_time'] != '00:00' && $_POST['Todolist']['end_time'] != '') {
                $model->end_time = date("H:i", strtotime($model->end_time));
            }        
            if ($model->validate()) {
                $model->save();
                $model->refresh();
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);          
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
          
    }
}
