<?php

class TempuploadController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('UploadInventoryFile', 'UploadDayBook', 'Downloadformat', 'SaveDayBookUpload','DownloadErrorLog'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionUploadDayBook() {
        $this->render('upload_daybook_form');
    }

    public function actionDownloadformat() {
        $data = array();
        $data[0][0] = 'Date';
        $data[0][1] = 'Particulars';
        $data[0][2] = 'Voucher Type';
        $data[0][3] = "Voucher No";
        $data[0][4] = "Debit Amount";
        $data[0][5] = "Credit Amount";

        $this->array_to_csv_download($data, "UPLOAD_DayBook.csv");
    }

    public function readCSV($csvFile) {

        $row = 1;
        if (($file_handle = fopen($csvFile, "r")) !== FALSE) {
            while (($contents = fgetcsv($file_handle, 1024, ",")) !== FALSE) {
                $line_of_text[] = $contents;
            }
            fclose($file_handle);
        }
        return $line_of_text;
    }

    public function actionSaveDayBookUpload() {
        $jsonData['errors'] = array();
        $flag = 0;
        $valid = true;
        if (isset($_POST['UploadDayBook'])) {

            $file_name = $_POST['UploadDayBook']['uploadfile'];
            $from_file = $this->readCSV("upload/daybook/" . $file_name);
            $jsonData = array();
            $voucher_date = $particulars = $voucher_type = $voucher_no = $debit_amount = $credit_amount = '';
            foreach (array_slice($from_file, 1) as $i => $eachItem) {
                $voucher_date = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
                $particulars = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                $voucher_type = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                $voucher_no = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                $debit_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                $credit_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));

                /*                 * ********   check Empty ***************************** */
                $j=$i+2;
                if (strlen($voucher_date) > 0 || strlen($particulars) > 0 || strlen($voucher_type) > 0 || strlen($voucher_no) > 0 || ($debit_amount > 0 || $credit_amount > 0)) {
                    if ($voucher_date == '') {
                        $arr_error[] = 'Please Add Date in line ' . $j.';';
                        $flag = 1;
                    }
                    if ($particulars == '') {
                        $arr_error[] = 'Please Add Particulars in line ' . $j.';';
                        $flag = 1;
                    }
                    if ($voucher_type == '') {
                        $arr_error[] = 'Please Add voucher type in line ' . $j.';';
                        $flag = 1;
                    }
                    if ($voucher_no == '') {
                        $arr_error[] = 'Please Add Voucher no in line ' . $j.';';
                        $flag = 1;
                    }
                    if (!($debit_amount > 0 || $credit_amount > 0)) {
                        $arr_error[] = 'Please Add Either Debit Or Credit amount in line ' . $j.';';
                        $flag = 1;
                    }


                    if ($flag == 0) {
                        $modelTemp[$i] = new TempUploadDayBookFinance();
                        $modelTemp[$i]->voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
                        ;
                        $modelTemp[$i]->particulars = $particulars;
                        $modelTemp[$i]->voucher_type = $voucher_type;
                        $modelTemp[$i]->voucher_no = $voucher_no;
                        $modelTemp[$i]->debit_amount = $debit_amount;
                        $modelTemp[$i]->credit_amount = $credit_amount;
                        $valid = $modelTemp[$i]->validate() && $valid;
                    }
                }
            }
            $jsonData['errors'] = array();
            if ($flag == 1) {
                $jsonData['status'] = "error";
                $jsonData['errors'] = ltrim(implode("<br>", $arr_error), ",");
                $error_url = 'upload/daybook/error/'.$file_name;
                $file_error = fopen($error_url, "w+");
                foreach ($arr_error as $line){
                    $eachline=array();
                    $eachline[]=$line;
                    fputcsv($file_error, $eachline); 
                }
                fclose($file_error);
                $jsonData['filename'] = $file_name;
                $jsonData['link'] = CHtml::link('Download log', array('tempupload/DownloadErrorLog', 'file_name' => $file_name), array('target' => '_blank',
                            'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                            . ''
                ));
            } else {
                TempUploadDayBookFinance::model()->deleteAll();
                foreach ($modelTemp as $eachModel) {
                    $eachModel->save(false);
                }
                $jsonData['status'] = "success";
                $jsonData['model'] = $modelTemp;
            }
            echo CJSON::encode($jsonData);
        } else {

            $jsonData['status'] = "fail";
            echo CJSON::encode($jsonData);
        }
    }

    public function actionDownloadErrorLog() {
        $file_name = Yii::app()->request->getParam('file_name');
        $error_url = 'upload/daybook/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }

}
