<?php 
class StockmismatchController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','GetDefaultWarehouseMissingList','GetProductLocationMissingList','DefaultWarehouseMissingList','InsertProductLocation','StockDifference','StockDifferenceList'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }
    
    public function actionGetProductLocationMissingList(){
                $model=new ProductLocation();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'country_name',
                   1 =>'country_code',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = ' WHERE id NOT IN (SELECT stock_id FROM crm_product_location)';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" AND (part_number LIKE '%".$searchString."%' OR description LIKE '%".$searchString."%')";
                }
                /*$count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));*/
                
                $SQL="SELECT `id`, `part_number`, `description` FROM `crm_store` ".$condition;
                $arr_list = Yii::app()->db->createCommand($SQL)->queryAll();
                
                $count = count($arr_list);
                
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                foreach ($arr_list as $row)
                {
                    $div = '';
                    /*if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_country_edit"])){
                        $div .=   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'country/create&id='.$row['id'].'\',\'Edit Currency\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_country_delete"])){
                       // $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCountry('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }*/
                    $rowData[]=array($m,$row['id'],$row['part_number'],$row['description'],'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    
    public function actionDefaultWarehouseMissingList() {
        $this->render('defaultwarehousemissinglist');
    }
    
    public function actionGetDefaultWarehouseMissingList(){
                $model=new MasInvWarehouse();
                
                $arr_default_ware_house_details = $model->getDefaultWarehouse();
                
                $default_warehouse_id = $arr_default_ware_house_details->id;
                
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'country_name',
                   1 =>'country_code',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = ' WHERE id NOT IN (SELECT stock_id FROM crm_product_location  WHERE warehouse_id='.$default_warehouse_id.')';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" AND (part_number LIKE '%".$searchString."%' OR description LIKE '%".$searchString."%')";
                }
                
                $SQL="SELECT `id`, `part_number`, `description` FROM `crm_store` ".$condition;
                $arr_list = Yii::app()->db->createCommand($SQL)->queryAll();
                
                $count = count($arr_list);
                
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                foreach ($arr_list as $row)
                {
                    $div = '';
                    /*if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_country_edit"])){
                        $div .=   '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'country/create&id='.$row['id'].'\',\'Edit Currency\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_country_delete"])){
                       // $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCountry('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }*/
                    $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="insertMissingLocation('.$row['id'].')"><i class="fa fa-plus"></i> INSERT</a>';
                    $rowData[]=array($m,$row['id'],$row['part_number'],$row['description'],'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    
    public function actionInsertProductLocation(){
        $stock_id = Yii::app()->request->getParam('id');
        
        //$stock_id=69001;
        
        $model=new MasInvWarehouse();
                
        $arr_default_ware_house_details = $model->getDefaultWarehouse();
        $default_warehouse_id = $arr_default_ware_house_details->id;
        
        $modelProductLocation = new ProductLocation();
        $count = $modelProductLocation->count(array('condition'=>'stock_id='.$stock_id." AND warehouse_id=".$default_warehouse_id));
        if($count==0){       
            $SQL = "INSERT INTO crm_product_location (stock_id, bin, rack, warehouse_id,is_default_warehouse_id	,quantity,created_by,updated_by,created_date_time,updated_date_time) VALUES (".$stock_id.", 0, 0, ".$default_warehouse_id.",'Y',0,30,0,'".date('Y-m-d h:i:s')."','0000-00-00 00:00:00')";
            //echo $SQL;
            Yii::app()->db->createCommand($SQL)->execute();
            $json['status'] = "success";
            
        }
        else{
            $json['status'] = "fail";
        }
        
        echo json_encode($json);
        
    }
    
    public function actionStockDifference(){
         $this->render('stockdifference');
    }
    
    public function actionStockDifferenceList(){
                
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'part_number',
                   1 =>'description',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = ' WHERE 1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" AND (part_number LIKE '%".$searchString."%' OR description LIKE '%".$searchString."%')";
                }
                
                $SQL ="SELECT id,part_number,description,SUM(loc_total_quantity) AS loc_total_quantity,opening_quantity,SUM(in_qty) AS total_in_qty,SUM(out_qty) AS total_out_qty FROM view_stock_difference ".$condition." GROUP BY id";
                $arr_list = Yii::app()->db->createCommand($SQL)->queryAll();
                
                $count = count($arr_list);
                
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                foreach ($arr_list as $row)
                {
                        $transaction_qty = (($row['opening_quantity'] + $row['total_in_qty']) - $row['total_out_qty']);
                        if($transaction_qty!=$row['loc_total_quantity']){
                            $rowData[]=array($m,$row['id'],$row['part_number'],$row['description'],Yii::app()->numberFormatter->formatCurrency($row['loc_total_quantity'],""),Yii::app()->numberFormatter->formatCurrency($row['opening_quantity'],""),Yii::app()->numberFormatter->formatCurrency($row['total_in_qty'],""),Yii::app()->numberFormatter->formatCurrency($row['total_out_qty'],""));
                            $m++;
                        }
                }
                
                
                $data['data'] = $rowData;
                echo json_encode($data);
    }
}
?>