<?php
class SiteController extends Controller {
    /**
     * Declares class-based actions.
     */
    public function actions() {
        return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
            'captcha' => array(
                'class' => 'CCaptchaAction',
                'backColor' => 0xFFFFFF,
            ),
            // page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
            'page' => array(
                'class' => 'CViewAction',
            ),
        );
    }
        public function accessRules() {

        return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout','newlogin','
                  '),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','ChangePassword','UpdatePassword','Menu','GetAllDetailsForProduct','Pos','Getposdata','Addtocart','GetServiceemployees','ResetPassword','_Page','_Ipage',
                  'HrMasters','LoadMasterHrFilter','master_menu','admin_console','_Vehicle','LoadVehicleFilter','LoadMastersFilter'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

    }


    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
//    public function actionIndex() {
//            $this->render('index');
//    }
        public function actionIndex() {
           
            //$this->render('index');
        if(Yii::app()->user->authorised_user == 1)
        {
           $this->render('index');
        }else{
            if(Yii::app()->user->level == 2){
                $this->layout='main';
                $this->render('../../../modules/hr/views/hremployeeanalysis/dashboard');
                    
            }else{
                if(isset(Yii::app()->user->haveHrPermissionOn['hr_dashboard_as_default_menu'])){
                    $this->render('../../../modules/hr/views/site/welcome_page');
//                    $this->render('../hrdashboard/index');
                }else{
                    $this->render('index');
                }
            }
        }
    }
    public function action_Page() {
    if (
        Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view']
        )
    ) {
        $this->render('master_menu_new');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end();
    }
}

    public function action_Ipage() {
        //$this->render('_admin_page');
         $this->render('admin_console');
    }

     public function actionHrMasters() {
        $this->render('hr_masters');
    }

    public function actionmaster_menu() {
        $this->render('master_menu_new');
    }

    public function actionadmin_console()
    {
     $this->render('admin_console');
    }

    public function actionChangePassword() {
        $this->render('changepassword');
    }
    public function actionNewLogin() {
        $model = new LoginForm;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('login_new',array('model'=>$model));
    }
    public function actionUpdatePassword() {
        $curr_pwd      = $_POST['user_current_password'];
        $new_pwd       = $_POST['user_new_password'];
        $rep_pwd       = $_POST['user_reenter_password'];
        $login_user_id = Yii::app()->user->id;
        $arr_user_details= User::model()->findByPk($login_user_id);
        $salt       = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password   = crypt($_POST['user_current_password'], $salt);
        if($arr_user_details->password == $password){
            $new_password   = crypt($_POST['user_new_password'], $salt);
            $arr_user_details->password=$new_password;
            $arr_user_details->password_reset='Y';
            //token clear added by nisha on 01-06-2023
            $arr_user_details->token="";
            //end
            $arr_user_details->save(false);
            $json['status'] = "success";
        }
        else
        {  
            $json['status'] = "fail";
        }
        echo CJSON::encode($json);
    }
    public function actionMenu()
    {        
        $this->render('menu');
    }
    
     public function actionGetAllDetailsForProduct(){
        $product_id     = $_POST['product_id'];
        $customer_id    = $_POST['customer_id'];
        $modelStore = new Store();
        $product_details = $modelStore->findByPk($product_id);
        
        $brand_class_id=$product_details->brand_class_id;
        
        $modelCustomerPricing = new CustomerPricingGroup();
        $arr_customer_pricing_details = $modelCustomerPricing->find(array('condition'=>'customer_id='.$customer_id." AND brand_id=".$brand_class_id));
        
        
        
        $sales_pricing_group_id = (int) $arr_customer_pricing_details->pricing_group_id;
        
        $model = new SalesPriceGroup();
        $arr_price_details = $model->find(array('condition'=>'product_id='.$product_id));
        
        
        $price = 0;
        if($sales_pricing_group_id==1){
            $price = $arr_price_details->base_sales_price;
        }
        elseif($sales_pricing_group_id==2){
            $price = $arr_price_details->sales_price1;
        }
        elseif($sales_pricing_group_id==3){
            $price = $arr_price_details->sales_price2;
        }
        elseif($sales_pricing_group_id==4){
            $price = $arr_price_details->sales_price3;
        }
        elseif($sales_pricing_group_id==5){
            $price = $arr_price_details->sales_price4;
        }
        elseif($sales_pricing_group_id==6){
            $price = $arr_price_details->sales_price5;
        }
        elseif($sales_pricing_group_id==7){
            $price = $arr_price_details->sales_price6;
        }
        elseif($sales_pricing_group_id==8){
            $price = $arr_price_details->sales_price7;
        }
        else
        {
           $price = $arr_price_details->sales_price1; 
        }
        
        $jsonData['price'] = number_format(floatval($price), 2, '.', '');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
        
    }
    
    public function actionGetServiceemployees(){
        
        $searchTerm = trim($_GET['term']);
        $condition = 'employee_name LIKE "%' . $searchTerm . '%" OR designation LIKE "%' . $searchTerm . '%"';
        $model = new ServiceEmployee();
        $model = $model->findAll(array('select' => 'id,employee_name', 'condition' => $condition));
        foreach ( $model as $i => $eachModel ) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->employee_name;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionResetPassword() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('resetpassword');
    }
    public function actionUnauthorized()
{
    $this->layout = false; // ✅ This disables the default Yii layout
    $this->render('//front/site/unauthorised'); // ✅ Adjust path to your view
}



    public function actionLoadMastersFilter()
    {


        $report_from = Yii::app()->request->getparam('report_from');

        if ($report_from == 'salesgroup') {

            $this->renderPartial('//salesgroup/index');
        }

        if ($report_from == 'industry') {

        $this->renderPartial('//industry/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'quotationclose') {

        $this->renderPartial('//quotationclose/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'termsandcondition') {

            $this->renderPartial('//termsandcondition/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'aidashboard') {

            $this->renderPartial('//aidashboard/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'Workspace') {

        $this->renderPartial('application.modules.workspace.views.master.index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'warehouselist') {

            $this->renderPartial('//warehouse/index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'brandlist') {

            $this->renderPartial('//brand/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'racklist') {

            $this->renderPartial('//rack/index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'binlist') {

            $this->renderPartial('//bin/index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'unitlist') {

            $this->renderPartial('//unit/index', array('report_from' => $report_from), false, true);

        }

          if ($report_from == 'categorylist') {

            $this->renderPartial('//generic/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'taxlist') {

            $this->renderPartial('//tax/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'inventoryitemtypelist') {

            $this->renderPartial('//masitemtype/index', array('report_from' => $report_from), false, true);

        }
         if ($report_from == 'inventoryuploadpricinggroup') {

            $this->renderPartial('//salespricinggroup/change_sales_price_group_name', array('report_from' => $report_from), false, true);

        }

        
         if ($report_from == 'banklist') {

            $this->renderPartial('//bank/index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'currencielist') {

            $this->renderPartial('//currency/index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'paymenttermlist') {

            $this->renderPartial('//paymentterms/index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'countrylist') {

            $this->renderPartial('//country/index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'shippingmethodlist') {

            $this->renderPartial('//shippingmethod/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'documentslist') {

            $this->renderPartial('//masdocumenttype/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'incoterms') {

            $this->renderPartial('//incoTerms/index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'taskcategorylist') {

            $this->renderPartial('application.modules.workshop.views.taskcategory.index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'tasksubcategorylist') {

            $this->renderPartial('application.modules.workshop.views.tasksubcategory.index', array('report_from' => $report_from), false, true);

        }
         if ($report_from == 'externallabourlist') {

            $this->renderPartial('application.modules.workshop.views.externallabour.index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'masteronelist') {

            $this->renderPartial('//masProject1/index', array('report_from' => $report_from), false, true);

        }


         if ($report_from == 'mastertwolist') {

            $this->renderPartial('//masProject2/index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'masterthreelist') {

            $this->renderPartial('//masProject3/index', array('report_from' => $report_from), false, true);

        }
 
        /// hr menus
          if ($report_from == 'appraisaldepartmentlist') {

            $this->renderPartial('application.modules.hr.views.hrappraisaldepartment.index', array('report_from' => $report_from), false, true);

        }

         if ($report_from == 'goallist') {

            $this->renderPartial('application.modules.hr.views.hrmasappraisaltype.index', array('report_from' => $report_from), false, true);

        }
         if ($report_from == 'kpilist') {

            $this->renderPartial('application.modules.hr.views.hrappraisalquestion.index', array('report_from' => $report_from), false, true);

        }
        if ($report_from == 'approvalschemelist') {

            $this->renderPartial('application.modules.hr.views.approvalscheme.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'colorschemelist') {

            $this->renderPartial('application.modules.hr.views.hrmascolorcode.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrcountrylist') {

            $this->renderPartial('application.modules.hr.views.country.index', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'hrdepartmentlist') {
            $this->renderPartial('application.modules.hr.views.department.index', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'hrdesignationlist') {
            $this->renderPartial('application.modules.hr.views.designation.index', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'hremployeeexpensecomponentlist') {
            $this->renderPartial('application.modules.hr.views.masemployeeexpense.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hremployeepanelpermissionlist') {
            $this->renderPartial('application.modules.hr.views.hrpermission.index', array('report_from' => $report_from), false, true);
        }
          if ($report_from == 'hrgradelist') {
            $this->renderPartial('application.modules.hr.views.hrmasgrade.index', array('report_from' => $report_from), false, true);
        }
          if ($report_from == 'hrholidaylist') {
            $this->renderPartial('application.modules.hr.views.masholiday.index', array('report_from' => $report_from), false, true);
        }

         if ($report_from == 'hrproductslist') {
            $this->renderPartial('application.modules.hr.views.hrmasproduct.index', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'hrrecruitmentdepartmentlist') {
            $this->renderPartial('application.modules.hr.views.hrquestiontype.index', array('report_from' => $report_from), false, true);
        }

          if ($report_from == 'hrrecruitmentquestionlist') {
            $this->renderPartial('application.modules.hr.views.hrquestion.index', array('report_from' => $report_from), false, true);
        }

         if ($report_from == 'hrteamlist') {
            $this->renderPartial('application.modules.hr.views.masteamname.index', array('report_from' => $report_from), false, true);
        }
          if ($report_from == 'hrtrainingcourselist') {
            $this->renderPartial('application.modules.hr.views.hrmascourse.index', array('report_from' => $report_from), false, true);
        }

          if ($report_from == 'hrbanklists') {
            $this->renderPartial('application.modules.hr.views.bank.index', array('report_from' => $report_from), false, true);
        }

         if ($report_from == 'hrcurrencylist') {
            $this->renderPartial('application.modules.hr.views.currency.index', array('report_from' => $report_from), false, true);
        }
          if ($report_from == 'hrexpenselist') {
            $this->renderPartial('application.modules.hr.views.hrmasexpense.index', array('report_from' => $report_from), false, true);
        }

         if ($report_from == 'hreosclearancelist') {
            $this->renderPartial('application.modules.hr.views.eosdetails.mas_index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hreosgratuitylist') {
            $this->renderPartial('application.modules.hr.views.masgratuity.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hreospaymentlist') {
            $this->renderPartial('application.modules.hr.views.maseospayment.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrsalarytypelist') {
            $this->renderPartial('application.modules.hr.views.massalarytype.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrsalarylockedmonthsettinglist') {
            $this->renderPartial('application.modules.hr.views.salarysetting.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrsalaryprocedurelist') {
            $this->renderPartial('application.modules.hr.views.salarysetting.salary_procedure_index', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'hrcertificatelist') {
            $this->renderPartial('application.modules.hr.views.mascertificate.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrcompanydocumentlist') {
            $this->renderPartial('application.modules.hr.views.companydocument.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrdocumenttypelist') {
            $this->renderPartial('application.modules.hr.views.masdocument.index', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'hrdocumentexpirystatuslist') {
            $this->renderPartial('application.modules.hr.views.masexpirystatus.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrinoutdocumentlist') {
            $this->renderPartial('application.modules.hr.views.masinout.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrjobcontractlist') {
            $this->renderPartial('application.modules.hr.views.hrmasjobcontract.index', array('report_from' => $report_from), false, true);
        }
      if ($report_from == 'hrasssetlist') {
            $this->renderPartial('application.modules.hr.views.hrmasasset.index', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'hrassetdetailslist') {
            $this->renderPartial('application.modules.hr.views.hrmasassetdetails.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrbranchlist') {
            $this->renderPartial('application.modules.hr.views.branch.index', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'hrgeocodelocationlist') {
            $this->renderPartial('application.modules.hr.views.masgeocodelocation.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hremployeegeocodelist') {
            $this->renderPartial('application.modules.hr.views.employeegeocode.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrleavetypelist') {
            $this->renderPartial('application.modules.hr.views.masleave.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrnoticeperiodlist') {
            $this->renderPartial('application.modules.hr.views.masnoticeperiod.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrovertimetypelist') {
            $this->renderPartial('application.modules.hr.views.overtime.index', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'hrpensionsettingslist') {
            $this->renderPartial('application.modules.hr.views.pensionsettings.index', array('report_from' => $report_from), false, true);
        }
          if ($report_from == 'hrrelationtypelist') {
            $this->renderPartial('application.modules.hr.views.hrmasrelation.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hrshiftlist') {
            $this->renderPartial('application.modules.hr.views.masshift.index', array('report_from' => $report_from), false, true);
        }
         if ($report_from == 'hremployeesignaturelist') {
            $this->renderPartial('application.modules.hr.views.certificateauth.index', array('report_from' => $report_from), false, true);
        }
        
          if ($report_from == 'Notification') {

            $this->renderPartial('//notificationtype/index', array('report_from' => $report_from), false, true);

        }
        if ($report_from == 'sourceoflead') {

        $this->renderPartial('//massourceoflead/index', array('report_from' => $report_from), false, true);

        }
        if ($report_from == 'status') {

                $this->renderPartial('//masstatus/index', array('report_from' => $report_from), false, true);

        }
        if ($report_from == 'mas_fixed_assts') {

            $this->renderPartial('application.modules.fixedasset.views.default.index', array('report_from' => $report_from), false, true);

        }
        if ($report_from == 'fixed_assts_reg') {

                $this->renderPartial('application.modules.fixedasset.views.register.index', array('report_from' => $report_from), false, true);

        }
        if ($report_from == 'fix_assts_depr') {

                $this->renderPartial('application.modules.fixedasset.views.depreciate.index', array('report_from' => $report_from), false, true);

        }
        if ($report_from == 'aggregate_fix_assts_depr') {

                $this->renderPartial('application.modules.fixedasset.views.depreciate.aggregateindex', array('report_from' => $report_from), false, true);
        }

    }
    
    
      public function action_Vehicle() {
    //if (
    //     Yii::app()->user->authorised_user == 1 ||
    //     (
    //         isset(Yii::app()->user->havePermissionOn['masters_menu_view']) &&
    //         Yii::app()->user->havePermissionOn['masters_menu_view']
    //     )
    // ) {
        $this->render('vehicle_menu_new');
    // } else {
    //     $this->layout = false;
    //     $this->render('/site/unauthorised');
    //     Yii::app()->end();
    // }
}



    public function actionLoadVehicleFilter()
    {


        $report_from = Yii::app()->request->getparam('report_from');

        if ($report_from == 'vehicle') {

            $this->renderPartial('application.modules.vehicle.views.masvehicle.index');
        }

        if ($report_from == 'maintainance_type') {

        $this->renderPartial('application.modules.vehicle.views.masmaintainance.index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'service_status') {

        $this->renderPartial('application.modules.vehicle.views.masservicestatus.index', array('report_from' => $report_from), false, true);

        }

        if ($report_from == 'vehicle_maintainance') {

            $this->renderPartial('application.modules.vehicle.views.masMaintainanceService.index', array('report_from' => $report_from), false, true);

        }
        if ($report_from == 'vehicle_allotment') {

            $this->renderPartial('application.modules.vehicle.views.vehicleallotment.index', array('report_from' => $report_from), false, true);

        }

        
    }
    
}
