<?php

class SettingsController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteSetting','SaveSetting','GetSettingList','MasterSetting','Index1'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        $this->render('index');
         }
         public function actionIndex1() {
        $this->render('setting_form');
         }
         
        public function actionGetSettingList()
         {
 
                $model=new MasSetting();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
                   1 =>'decimal_value',
                   2=>'profit_percent'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.is_Active="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (decimal_value LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                         
                    $rowData[]=array($m,$row['decimal_value'],$row['profit_percent'],
              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'settings/create&id='.$row['id'].'\',\'Edit Settings\',\'lg\')"><i class="fa fa-pencil"></i></button> '
             .'</div>');
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }//'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteSetting('.$row['id'].')"><i class="fa fa-trash-o "></i></a>
    public function actionCreate()
    {
        $model=new MasSetting(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('setting_form', array('model' => $model));
    }
    public function actionMasterSetting() {
        $id = 1;
		$model = MasSetting::model()->findByPK($id);
		if(empty($model)){
		    $model = new MasSetting();
		}
		Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('/settings/setting_form', array('model'=>$model), false, true);
    }
    public function actionSaveSetting()
        {
            $model = new MasSetting();
            if (isset($_POST['MasSetting']))
            {   $model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['MasSetting']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasSetting']['id'];
                    $model=$model->findByPk($id); 
                }
                $model->attributes=$_POST['MasSetting'];
                if($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['setting_form'];
                        $jsonData['id'] = $model->id;
	                    echo CJSON::encode($jsonData);
                       
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
               

            }
        }
        public function actionDeleteSetting()
    {
		$id = $_POST['id'];
                $model=new MasSetting();
                $model->deleteByPk($id);
                echo "success";
    }
        
        
  
}