<?php

class SampletrackController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('trackingIndex','GetList','AddDemo','SearchProduct','Savedemo','DemoReturnDetails','GetItemsDemoReturn','SaveReturnDemoItem','Print',
                'GetStockDetails','AddQuantityDetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    
    public function filters() {
        return array('accessControl'); 
    }
    public function actionTrackingIndex()
    {
            $this->render('index');
    }
    public function actionGetList()
    {
            $model=new DemoItemGeneral();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            $columns = array(
                // datatable column index  => database column name
                0=>'id',
                1=>'customer_detail.customer_name',
                2=>'item_issue_date',
                4=>'reference',
            );
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            $orderBy      = $filterColumn." ".$filterOrder;
            $condition = 't.id !=""';
            if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
            {
                    $searchString = $_POST['search']['value'];
                    //$condition.=" AND ( vendor_details.vendor_name LIKE '%".$searchString."%' OR  t.file_id LIKE '%".$searchString."%' OR t.id LIKE '%".$searchString."%' OR awb_no LIKE '%".$searchString."%' OR t.po_id LIKE '%".$searchString."%')";
                    $condition.=" AND ( customer_detail.customer_name LIKE '%".$searchString."%' OR reference LIKE '%".$searchString."%' OR  t.item_issue_date LIKE '%".$searchString."%')";
            }
            
            $count = $model->with('customer_detail')->count(array('condition'=>$condition));
            $model = $model->with('customer_detail')->findAll(array('condition'=>$condition,'order' =>'t.id DESC','limit'=>$limit,'offset'=>$offset));
            
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            $status='';
            $m = 1;
            foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["other_sampletracking_return"])){
                       $div .= '<button title="Return Details" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'sampletrack/demoReturnDetails&id='.$row['id'].'\',\'Return Details \',\'xl\');"><i class="fa fa-arrow-down" aria-hidden="true"></i></button>';
                       $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=sampletrack/print&id='.$row['id'].'"><i class="fa fa-file-pdf-o"></i></a>';
                    }
                    $rowData[]=array($m,$row['customer_detail']['customer_name'],date('d/m/Y',strtotime($row['item_issue_date'])),$row['reference'],'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
            $data['data'] = $rowData;
            echo json_encode($data);


    }
    public function actionAddDemo() {
       
        $modelDemo= new DemoItemGeneral;
        $modelDemoItems = array(new DemoItemDetails);
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $modelDemo = $modelDemo->findByPK($id);
            $modelDemoItems = DemoItemDetails::model()->findAll(array('condition' =>'demo_monitoring_id = '.$id.' '));
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('_demoform', array('modelDemo' => $modelDemo,'modelDemoItems' => $modelDemoItems), false, true);
        //echo "ok";
    }
    public function actionSearchProduct() {
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%"';
        $model = new Store();
        $model = $model->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['unit'] = $eachModel->unit_id;
            $data[$i]['service_item_name'] = $eachModel->inventory_item_type;        
           
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    /*public function actionSavedemo(){
        $modelDemo = new DemoItemGeneral;
        $modelDemoitems = array(new DemoItemDetails());
        $othererror=array();
        if (isset($_POST['DemoItemGeneral'])) {
            if ((int) $_POST['DemoItemGeneral']['id'] > 0) {
                $modelDemo = $modelDemo->findByPK($_POST['DemoItemGeneral']['id']);
                $modelDemo->scenario = 'update';
            }
            $modelDemo->attributes = $_POST['DemoItemGeneral'];
            
            
            //$modelDemo->item_issue_date = $_POST['DemoItemGeneral']['item_issue_date'];
            
            if($_POST['DemoItemGeneral']['item_issue_date']!='00/00/0000' && $_POST['DemoItemGeneral']['item_issue_date']!=''){
                $modelDemo->item_issue_date = str_replace('/', '-', $_POST['DemoItemGeneral']['item_issue_date']);
                $modelDemo->item_issue_date= date("Y-m-d H:i", strtotime($modelDemo->item_issue_date));
            }
            
            $modelDemo->crm_user_id = Yii::app()->user->id;
            $valid = $modelDemo->validate();
            $validItem = true;
            $warehouse=MasInvWarehouse::model()->find(array('condition'=>'isBaseWareHouse="Y"'));                    
            if (is_array($_POST['DemoItemDetails'])) {
                foreach ($_POST['DemoItemDetails'] as $i => $item) {
                    if($item["product_id"]>0){
                    $modelDemoitems[$i] = new DemoItemDetails();
                    if ($item['id'] > 0) {
                        $modelDemoitems[$i] = $modelDemoitems[$i]->findBypk($item['id']);
                        $qty=($item['picked_qty']-$modelDemoitems[$i]->picked_qty);
                    }
                    else{
                        $qty=$item['picked_qty'];
                    }
                    $modelDemoitems[$i]->attributes = $_POST['DemoItemDetails'][$i];
                    $SQL='SELECT SUM(quantity) AS quantity FROM crm_product_location WHERE stock_id='.$item["product_id"].' AND warehouse_id='.$warehouse->id;
                    $count = Yii::app()->db->createCommand($SQL)->queryScalar();
                    
                    if($count <$qty){
                        $validItem = FALSE;
                        $othererror[]='Default Warehouse has Insufficient Quantity';
                    }
                    $validItem = $modelDemoitems[$i]->validate() && $validItem;
                    }
                }
            }

            $valid = $valid && !empty($modelDemoitems);
            $modelsToBeValidated = array($modelDemo, $modelDemoitems);
            if ($valid) {
                
                $modelDemo->save();
                $demo_id = $modelDemo->id;
                $modelDemo->refresh();
                foreach ($modelDemoitems as $eachModel) {
                    $eachModel->demo_monitoring_id = $demo_id;
                    if($eachModel->id>0)
                    {
                        $mod=DemoItemDetails::model()->findByPk($eachModel->id);
                        $qty=($eachModel->picked_qty)-($mod->picked_qty);
                    }
                    else {
                        $qty=$eachModel->picked_qty;   
                    }
                    $this->updateInventoryStock($eachModel->product_id, $warehouse->id, $qty, 0,'transferded');
                    $eachModel->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($modelDemo, '', false), true);
                if ($modelDemoitems[0]->product_id !=''){
                    $error2 = json_decode(CActiveForm::validateTabular($modelDemoitems, '', false), true);
                }
                else{
                    $error2[] = "Please add atleast one line item";
                }
              
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$othererror));
                if ($error != '[]')
                    echo $error;
            }

           
        }
        
        
    }*/
    
    
    public function actionSavedemo(){
        $modelDemo = new DemoItemGeneral;
        $modelDemoitems = array(new DemoItemDetails());
        $othererror=array();
        if (isset($_POST['DemoItemGeneral'])) {
            if ((int) $_POST['DemoItemGeneral']['id'] > 0) {
                $modelDemo = $modelDemo->findByPK($_POST['DemoItemGeneral']['id']);
                $modelDemo->scenario = 'update';
            }
            $modelDemo->attributes = $_POST['DemoItemGeneral'];
            
            
            //$modelDemo->item_issue_date = $_POST['DemoItemGeneral']['item_issue_date'];
            
            if($_POST['DemoItemGeneral']['item_issue_date']!='00/00/0000' && $_POST['DemoItemGeneral']['item_issue_date']!=''){
                $modelDemo->item_issue_date = str_replace('/', '-', $_POST['DemoItemGeneral']['item_issue_date']);
                $modelDemo->item_issue_date= date("Y-m-d H:i", strtotime($modelDemo->item_issue_date));
            }
            
            $modelDemo->crm_user_id = Yii::app()->user->id;
            $valid = $modelDemo->validate();
            $validItem = true;
            //$warehouse=MasInvWarehouse::model()->find(array('condition'=>'isBaseWareHouse="Y"'));                    
            if (is_array($_POST['DemoItemDetails'])) {
                foreach ($_POST['DemoItemDetails'] as $i => $item) {
                    if($item["product_id"]>0){
                    $modelDemoitems[$i] = new DemoItemDetails();
                    if ($item['id'] > 0) {
                        $modelDemoitems[$i] = $modelDemoitems[$i]->findBypk($item['id']);
                        $qty=($item['picked_qty']-$modelDemoitems[$i]->picked_qty);
                    }
                    else{
                        $qty=$item['picked_qty'];
                    }
                    $modelDemoitems[$i]->attributes = $_POST['DemoItemDetails'][$i];
                    /*$SQL='SELECT SUM(quantity) AS quantity FROM crm_product_location WHERE stock_id='.$item["product_id"].' AND warehouse_id='.$warehouse->id;
                    $count = Yii::app()->db->createCommand($SQL)->queryScalar();
                    
                    if($count <$qty){
                        $validItem = FALSE;
                        $othererror[]='Default Warehouse has Insufficient Quantity';
                    }*/
                    $validItem = $modelDemoitems[$i]->validate() && $validItem;
                    }
                }
            }

            $valid = $valid && !empty($modelDemoitems);
            $modelsToBeValidated = array($modelDemo, $modelDemoitems);
            if ($valid) {
                
                $modelDemo->save();
                $demo_id = $modelDemo->id;
                $modelDemo->refresh();
                foreach ($modelDemoitems as $eachModel) {
                    $eachModel->demo_monitoring_id = $demo_id;
                    if($eachModel->id>0)
                    {
                        $mod=DemoItemDetails::model()->findByPk($eachModel->id);
                        $qty=($eachModel->picked_qty)-($mod->picked_qty);
                    }
                    else {
                        $qty=$eachModel->picked_qty;   
                    }
                    
                    $eachModel->save();
                }
                /**************************  History of Demo Material Items  **************************/
                        if(is_array($_POST['Data'])){
                        foreach($_POST['Data'] as $each){
                            if($each['material_receipt_id'] > 0 && $each['picked_qty'] > 0){
                                $stock = MaterialReceiptStockDetails::model()->findbypk($each['material_receipt_id']);
                                
                                /*Saving */
                                $materialDetails = new DemoMaterialDetails;
                                $materialDetails->demo_monitoring_id    = $demo_id;
                                $materialDetails->material_receipt_id   =  $stock->id;
                                $materialDetails->material_receipt_qty  =  $stock->quantity;
                                $materialDetails->received_qty =  $each['picked_qty'];
                                $materialDetails->bill_exit = $each['bill_of_exit'];
                                $materialDetails->created_by = Yii::app()->user->id;
                                $materialDetails->created_date_time  = date('Y-m-d h:i:s');
                                $materialDetails->save(false);
    
                                $stock->quantity = (float) $stock->quantity -  (float) $each['picked_qty'];
                                $stock->save(false);
                                
                                /*Inventory Update*/
                                $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id='.$stock->product_id.' ')->queryScalar();
                                /**
                                 * Variables
                                 */
                                $warehouse = $stock->warehouse_id;
                                $rack = $stock->rack_id;
                                $bin = $stock->bin_id;
                                $con = 'stock_id='. $stock->product_id;
                                if($warehouse > 0)
                                    $con .= ' AND warehouse_id='.$warehouse;
                                if($rack > 0)
                                    $con .= ' AND rack='.$rack;
                                if($bin > 0)
                                    $con .= ' AND bin='.$bin;
                                $productlocation = ProductLocation::model()->find(array('condition' => $con));
                                if( $productlocation->id > 0){
                                    $loc = ProductLocation::model()->findByPk($productlocation->id);
                                    $loc->quantity = (float) $loc->quantity - (float) $each['picked_qty'];
                                    $loc->save(false);
                                }
                                Store::model()->updateByPk($stock->product_id, array('total_quantity' => ($old_total_qty -$each['picked_qty'])));
                            }
                        }
                    }
                    /**************************          ***************/
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($modelDemo, '', false), true);
                if ($modelDemoitems[0]->product_id !=''){
                    $error2 = json_decode(CActiveForm::validateTabular($modelDemoitems, '', false), true);
                }
                else{
                    $error2[] = "Please add atleast one line item";
                }
              
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$othererror));
                if ($error != '[]')
                    echo $error;
            }

           
        }
        
        
    }
    public function actionDemoReturnDetails() {
       
        $modelDemo= new DemoItemGeneral;
        $modelDemoItems = array(new DemoItemDetails);
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $modelDemo = $modelDemo->findByPK($id);
            $modelDemoItems = DemoItemDetails::model()->findAll(array('condition' =>'demo_monitoring_id = '.$id.' '));
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('_demoreturnform', array('modelDemo' => $modelDemo,'modelDemoItems' => $modelDemoItems), false, true);
    }
    public function actionGetItemsDemoReturn()
    {
        $id=Yii::app()->request->getParam('id');   
        $data=DemoItemDetails::model()->findByPk($id);
        $edit=DemoItemDetailsReturn::model()->findAll(array('condition'=>'demo_item_id='.$id,'order'=>'id'));
        if(!empty($edit))
        {
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $this->renderPartial('_edit_demo_item_return', array('data'=>$data,'id'=>$id,'edit'=>$edit), false, true);
        }
        else {
            $model= new DemoItemDetailsReturn;
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $this->renderPartial('_demo_item_return', array('data'=>$data,'id'=>$id,'edit'=>$edit,'model'=>$model), false, true);
        }
    }
  
    public function actionSaveReturnDemoItem()
    {
        
        $item_id=$_POST['DemoItemDetailsReturn'][0]['demo_item_id']; 
        $model=DemoItemDetails::model()->findByPk($item_id);
        $DemoItemDetailsReturn = array(new DemoItemDetailsReturn);
        
        $modelReturnCount = DemoItemDetailsReturn::model()->find(array('select' => 'SUM(return_qty) AS return_qty' ,  'condition' => 'demo_item_id = '.$item_id));         
        $qty  = $modelReturnCount->return_qty;
        $valid = true;
        
        if (is_array($_POST['DemoItemDetailsReturn'])) {
            foreach ($_POST['DemoItemDetailsReturn'] as $i=>$item) {
                
                if($_POST['DemoItemDetailsReturn'][$i]['id']>0)
                {
                    $DemoItemDetailsReturn[$i] = DemoItemDetailsReturn::model()->findByPk($_POST['DemoItemDetailsReturn'][$i]['id']);                       
                }
                else {
                    $DemoItemDetailsReturn[$i] = new DemoItemDetailsReturn;
                }
                $DemoItemDetailsReturn[$i]->attributes = $_POST['DemoItemDetailsReturn'][$i];
                $DemoItemDetailsReturn[$i]->serial_no = $_POST['DemoItemDetailsReturn'][$i]['serial_no'];

                if($_POST['DemoItemDetailsReturn'][$i]['return_date']!='00/00/0000'){
                    $DemoItemDetailsReturn[$i]->return_date = str_replace('/', '-', $_POST['DemoItemDetailsReturn'][$i]['return_date']);
                    $DemoItemDetailsReturn[$i]->return_date= date("Y-m-d H:i", strtotime($DemoItemDetailsReturn[$i]->return_date));
                }

                $qty+=$DemoItemDetailsReturn[$i]->return_qty;
                
                $valid = $DemoItemDetailsReturn[$i]->validate() && $valid;    
                
            }            
    	}
        
        if (!empty($_POST['MaterialReceiptStockDetails'])){
                
            foreach ($_POST['MaterialReceiptStockDetails'] as $i => $item) {
                if ($item['quantity']>0) {
                    if($item['id']>0){
                        $model_stock_item[$i] = MaterialReceiptStockDetails::model()->findByPk($item['id']);
                        $model_stock_item[$i]->updated_by       = Yii::app()->user->id;
                        $model_stock_item[$i]->updated_date =date('Y-m-d');                        
                    }else{
                        $model_stock_item[$i] = new MaterialReceiptStockDetails();
                        $model_stock_item[$i]->created_by  = Yii::app()->user->id;
                        $model_stock_item[$i]->created_date = date('Y-m-d');                        
                    }
                    $model_stock_item[$i]->attributes = $_POST['MaterialReceiptStockDetails'][$i]; 
                    $model_stock_item[$i]->warehouse_id =$item['warehouse_id'];
                    $model_stock_item[$i]->material_receipt_date ="0000-00-00";
                    $model_stock_item[$i]->stock_affect_date =date("Y-m-d");
                    $batch_mandty     = $item['batch_mandty'];
                    $serial_mandty    = $item['serial_mandty'];
                    if($batch_mandty==1){
                        $model_stock_item[$i]->batch_no =$item['batch_no'];
                        $item['expiry_date']= str_replace('/', '-',$item['expiry_date']);
                        $model_stock_item[$i]->expiry_date= date("Y-m-d", strtotime($item['expiry_date']));
                        $item['manufacture_date']= str_replace('/', '-',$item['manufacture_date']);
                        $model_stock_item[$i]->manufacture_date= date("Y-m-d", strtotime($item['manufacture_date']));
                    }
                    $model_stock_item[$i]->stock_affect_date= date("Y-m-d");
                    $model_stock_item[$i]->material_receipt_date= date("Y-m-d");
                    //if($serial_mandty==1){
                        $model_stock_item[$i]->serial_no =$item['serial_no'];
                    //}
                    $model_stock_item[$i]->transaction_type= 'Demo Items Return';
                    $model_stock_item[$i]->material_receipt_id = $item_id;
                    $model_stock_item[$i]->tot_quantity = $item['quantity'];
                    $model_stock_item[$i]->quantity = $item['quantity'];
                    $valid = $model_stock_item[$i]->validate() && $valid;
                }
            }
        }
        $valid = $valid && ($DemoItemDetailsReturn[0]->demo_item_id > 0);
        
        if($model->picked_qty>=$qty)
        { 
            if($valid)
            {  
          //  DemoItemDetailsReturn::model()->deleteAll(array('condition'=>'demo_item_id='.$item_id));    
                foreach ($DemoItemDetailsReturn as $k=>$eachModel) {
                  //  $eachModel->demo_item_id = $item_id;
                  $eachModel->return_qty = $qty;
                    if($eachModel->id>0)
                    {
                        $mod=DemoItemDetailsReturn::model()->findByPk($eachModel->id);
                        $qty=($eachModel->return_qty)-($mod->return_qty);
                    }
                    else {
                        $qty=$eachModel->return_qty;   
                    }
                    $eachModel->save();
                }
                foreach ($model_stock_item as $each_item) {
                    
                    $each_item->material_receipt_id = $item_id;                                
                    
                    
                        $each_item->save(false);                                                 
                    
                    /***************  save product Location *********************************/
                    
                        $warehouse = $each_item->warehouse_id;
                        $rack      = $each_item->rack_id;
                        $bin       = $each_item->bin_id;
                        $qty1       = $each_item->quantity;
                        
                        //$cur_total = $product->rate * $qty;
                        $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id='.$product_id.' ')->queryScalar();
                        $con = 'stock_id='. $product_id;
                        if($warehouse > 0)
                            $con .= ' AND warehouse_id='.$warehouse;
                        if($rack > 0)
                            $con .= ' AND rack='.$rack;
                        if($bin > 0)
                            $con .= ' AND bin='.$bin;
                        $productlocation = ProductLocation::model()->find(array('condition' => $con));
                        if( $productlocation->id > 0){
                            $loc = ProductLocation::model()->findByPk($productlocation->id);
                            $old = $loc->quantity;
                            $loc->quantity = $old+$qty1;
                            $loc->save(false);
                        }else{
                            $newloc = new ProductLocation;
                            $newloc->stock_id = $product_id;
                            $newloc->warehouse_id = $warehouse;
                            $newloc->rack = $rack;
                            $newloc->bin = $bin;
                            $newloc->quantity = $qty1;
                            $newloc->save(false);
                        }
                       // $old_net_amount = $product->rate * $old_total_qty;
                        //$new_amount = ($old_net_amount + $cur_total)/($old_total_qty + $qty);
                        
                        Store::model()->updateByPk($product_id, array('total_quantity' => ($old_total_qty + $qty1)));
                    }
                    /*************** END Save product Location ************************/

                //}
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);    
                }
                else {
                    $error2 = array();
                    $error1 = json_decode(CActiveForm::validateTabular($DemoItemDetailsReturn, '', false), true);
                    if(!empty($model_stock_item)){
                        $error2 = json_decode(CActiveForm::validate($model_stock_item, '', false), true);
                    }

                    $error = CJSON::encode(array_merge_recursive($error1,$error2));
                    if ($error != '[]')
                        echo $error;    
                }
        }
        else {
            $jsonData['status'] = 'fail';
            echo CJSON::encode($jsonData);    
        }
    }

    public function actionPrint(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.sample_tracking', array('id' => $id),true));
        $mPDF1->Output("sampletracking.pdf", 'I');
    }
    
    public function actionGetStockDetails(){
            
            $product_id = $_POST['product_id'];
            $quantity = $_POST['Qty'];
            $length = $_POST['length'];
            //$warehouse = $_POST['warehouse'];
            //$item_id   = $_POST['order_item_id'];
            $stock_details = array(new MaterialReceiptStockDetails);
            
            if((int) $product_id > 0){
                $product = Store::model()->findBypk($product_id);
                $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = '.$product_id.' AND quantity > 0', 'order' => 'quantity'));
            }
            
           
            $table = '';
            $flag   = 0;
            if($stock_details[0]->id > 0){
                
                foreach($stock_details as $each){
//                    $mod_alloc=new AllocatedMaterial();
//                    $alloc_qty=$mod_alloc->find(array('select'=>'SUM(quantity)AS quantity ','condition'=>'product_id = '.$product_id.' AND warehouse_id ='.$warehouse))->quantity;
//                    $free_qty=(float)((float)$each->quantity-(float)$alloc_qty);
                
                    $class = '';
                    if($each->expiry_date != '0000-00-00'){
                        $expire = date('d/m/Y',strtotime($each->expiry_date));
                        if(strtotime($each->expiry_date) < strtotime(date('Y-m-d'))){
                            $class = 'bg-danger';
                        }
                    }else{
                        $expire = '-';
                    }
                    if($each->stock_affect_date != '0000-00-00'){
                        $purchased = date('d/m/Y',strtotime($each->stock_affect_date));
                    }else{
                        $purchased = '-';
                    }
                    
                    $picked_qty  = "";
                    if($each->quantity <=$quantity AND $flag == '0'){
                        $picked_qty  = $each->quantity;
                        $quantity    = $quantity-$each->quantity;
                    }
                    else if($each->quantity >=$quantity AND $quantity>0 AND $flag == '0'){
                        $picked_qty  = number_format((float)$quantity, 2, '.', '');;                                 
                        $flag  = 1;                        
                    }
                     
                    $table .= '<tr class="deliveryItemsTR '.$class.'" id="deliveryitem_'.$item_id.'">';
                    $table .= '<td>'.$product->part_number.CHtml::hiddenfield('Data['.$length.'][product_id]',$product_id).CHtml::hiddenfield('Data['.$length.'][material_receipt_id]',$each->id).'</td>';
                    $table .= '<td>'.$each->rack->name.CHtml::hiddenfield('Data['.$length.'][rack_id]',$each->rack_id).'</td>';
                    $table .= '<td>'.$each->bin->name.CHtml::hiddenfield('Data['.$length.'][bin_id]',$each->bin_id).'</td>';
                    $table .= '<td>'.$each->batch_no.'</td>';
                    $table .= '<td>'.$each->serial_no.'</td>';
                    $table .= '<td>'.$purchased.'</td>';
                    $table .= '<td>'.$expire.'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][bill_of_exit]','',array('class' => 'form-control')).'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][qty_available]',$each->quantity,array('class' => 'form-control text-right','readonly' => 'readonly')).'</td>';
                    $table .= '<td>'.CHtml::textfield('Data['.$length.'][picked_qty]',$picked_qty,array('class' => 'form-control text-right','onkeyup' => 'verifyQty(this.id,this.value);')).'</td>';
                    $table .= '</tr>';
                    $length++;
                }

            }else{ 
                if($length == 0)
                    $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
            }

            echo $table;
        }
        
    public function actionAddQuantityDetails(){
        
        $return_id      = $_POST['return_id'];
        $modelDemoItem  = DemoItemDetails::model()->findbypk($return_id);
        $model_product  = Store::model()->findbypk($modelDemoItem->product_id);
      
        $product_name   = $model_product->part_number;
        $product_id     = $modelDemoItem->product_id;
        $quantity       = filter_var($_POST['quantity'], FILTER_VALIDATE_INT);
        $totalquantity  = filter_var($_POST['totalquantity'], FILTER_VALIDATE_INT);
        $newId          = $_POST['newId'];
        $model_material_stock  = new MaterialReceiptStockDetails(); 
        
        $batch_mandty      = 0;
        $serial_mandty     = 0;
        $color_mandatory   = "";
        $color_mandatory_1 = "";
        if($model_product->have_expiry_date=="Y"){
             $batch_mandty=1;
             $color_mandatory="bg-danger";
        }
         if($model_product->have_serial_no=="Y"){
             $serial_mandty=1;
             $color_mandatory_1="bg-danger";
        }
        
       
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($model_product->have_serial_no=="Y"){
            $this->render('material_receipt_stock_serial', array('model_material_stock' => $model_material_stock,'product_name' => $product_name,'product_id' => $product_id,'quantity' => $quantity,'newId' => $newId,'batch_mandty' => $batch_mandty,'serial_mandty' => $serial_mandty,'color_mandatory'=>$color_mandatory,'color_mandatory_1'=>$color_mandatory_1,'order_id'=>$order_id,'totalquantity'=>$totalquantity,'item_row_id'=>$item_row_id,'return_id'=>$return_id));
        }else{
            $this->render('material_receipt_stock', array('model_material_stock' => $model_material_stock,'product_name' => $product_name,'product_id' => $product_id,'quantity' => $quantity,'newId' => $newId,'batch_mandty' => $batch_mandty,'serial_mandty' => $serial_mandty,'color_mandatory'=>$color_mandatory,'color_mandatory_1'=>$color_mandatory_1,'order_id'=>$order_id,'totalquantity'=>$totalquantity,'item_row_id'=>$item_row_id,'return_id'=>$return_id));
        }
    }

}